package dressing.handlers;

import java.util.HashMap;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Shell;

import com.badlogic.gdx.math.Vector2;

import dressing.cam.model.PlanUsinage;
import dressing.model.Piece2D;
import dressing.cam.model.PlanUsinage;
import dressing.ui.parts.Edit2DPiece;
import gdxapp.scenes.Scene;
import gdxapp.screens.room3d.Room3DController;
import gdxapp.screens.room3d.Room3DScreen;
import reporting.Cotation;
import reporting.SVGGnerator;

public class GenSVGHandler {
	
@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(ParameterizedCommand command,EPartService partService,Shell shell){
		Piece2D piece = (Piece2D) selectionService.getSelection();
		SVGGnerator svgen = new SVGGnerator();
		HashMap<PlanUsinage, String> svg = svgen.generatefaceprojection(piece, new Vector2(600, 600));
		System.err.println(svgen.genSingleImageProjections(piece, new Vector2(2160,720), 50, 100, 0));
	}
	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection();
		if(o instanceof Piece2D)
			return true;
		return false;
	}

}
