package dressing.handlers;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import com.badlogic.gdx.Gdx;

import dressing.model.ProjectManager;
import gdxapp.scenes.Scene;
import gdxapp.screens.room3d.Room3DController;
import gdxapp.screens.room3d.Room3DScreen;

public class ExportScene3D {
	
	@Execute
	public void execute(Shell shell) {
		if(Scene.game.getScreen() instanceof Room3DScreen) {
			System.err.println("exporting scene 3d");
			Thread thread = new Thread(new Runnable() {
				@Override
				public void run() {
					Room3DController.getInstance().enhancedRender();
				}
			});
			thread.start();
		}
	}
	
	@CanExecute
	public boolean check() {
		return true;
	}

}
