package dressing.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;

import javax.inject.Inject;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.DesignException;
import dressing.model.Kitchen;
import dressing.model.ProjectManager;
import dressing.ui.parts.ProjectExplorerPart;
import param.MechanicDesign;

public class DuplicateKitchenHandler {
	
	@Inject 
	ESelectionService selectionService;
	
	@Inject
	EPartService partService;
	
	@Execute
	public void execute(Shell shell) {
		MPart part=partService.getActivePart();		
		if(part.getObject() instanceof ProjectExplorerPart) {
			Object selection=selectionService.getSelection(part.getElementId());
			if(selection instanceof Kitchen) {
				try {
					ProjectManager.getManager().getCurrentProject().addElement(((Kitchen) selection).copy());
				} catch (DesignException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
	}
	
	@CanExecute
	public boolean check() {
		if(ProjectManager.getManager().getCurrentKitchen()==null) {
			return false;
		}
		return true;
	}
}
