 
package dressing.handlers;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.config.WorkspaceConfiguration;
import dressing.ui.parts.Textures;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.CanExecute;

public class Addtexture {
	@Execute
	public void execute(Shell shell,EPartService partService) {
		FileDialog dialog = new FileDialog(shell);
		dialog.setFilterExtensions(new String[] {"*.png","*.jpg","*.jpeg","*.gif"});
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("project3d");
		String defaultpath=projectpref.get("directory", "c:");
		String dirpath = projectpref.get("directoryread", defaultpath);
		
		dialog.setFilterPath(dirpath);
		String filepath = dialog.open();
		if(filepath!=null && !filepath.isEmpty())
		{
		      
				 File f = new File(filepath);
				 if(f.getParent()!=null)
				 {	
					 projectpref.put("directoryread", f.getParent());
					 try {
						projectpref.flush();
					} catch (BackingStoreException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
			
				 }
					File origin = new File(WorkspaceConfiguration.getDefaultConfDir() + "/pictures");
					File destFile = new File(origin.getAbsolutePath() + File.separator + f.getName());
					if (!destFile.exists()) {
						System.err.println(destFile.setExecutable(true));
						System.err.println(destFile.setReadable(true));
						try {
							Files.copy(f.toPath(), new FileOutputStream(destFile));
						} catch (FileNotFoundException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}				
					for (MPart part : partService.getParts()) {
						if (part.getElementId().equals("dressing.part.Textures")) {
							Object p = part.getObject();
							if(p instanceof Textures) {
								((Textures) p).addTexture(destFile);
								((Textures)p).refresh(); 
							}
						
						  
						}					
					}
			

		}
	}
	
	
	
	@CanExecute
	public boolean canExecute() {
		
		return true;
	}
		
}