package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.ModelProvider;
import dressing.model.ProjectParent;
import dressing.ui.project3d.Project3DWizard;

public class AddProjectWizardHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell,EPartService partService){
	
		
		ProjectParent parent  = ModelProvider.RootInstance();
		//Voire l element de l arbre selectionne
		if(parent!=null)
		{
			
			Project3DWizard projectwizard = ContextInjectionFactory.make(Project3DWizard.class,eclipsecontext);
			projectwizard.setRoot(parent);
			WizardDialog dialog = new WizardDialog(shell, projectwizard);
			dialog.open();		

		}
		else
		{
			MessageDialog.openError(shell, "Impossible d'ajouter un projet", "Espace de travail non intilialisée");
		}
	}
	@CanExecute
	public boolean check()
	{
		if(eclipsecontext!=null)
		{
			if( ModelProvider.RootInstance()!=null)
			{
				return true;
			}
		}
		return false;
	}
}