package dressing.events;

public interface EventHandler {
	
	default void subscribe(String... topic) {
		for(int i = 0; i < topic.length; i++) {
			EventDriver.getDriver().registerSubscription(topic[i], EventHandler.this);
		}
	}
	
	default void unsubscribe(String... topics) {
		for(int i = 0; i < topics.length; i++) {
			EventDriver.getDriver().removeSubscription(topics[i], EventHandler.this);
		}
	}
	
	//unsubscribe from all topics
	default void unsubscribe() {
		EventDriver.getDriver().removeSubscriber(EventHandler.this);
	}
	
	public void handle(Event event);

}