package dressing.config.ui;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Iconmanager {
	

	
	    private Map<String, Image> iconMap = new HashMap<>();
	    

	    public Iconmanager() {
	      
	    }

	    public void loadIconsFromFolder(String folderPath,Display display) {
	        File folder = new File(folderPath);
	        if (!folder.isDirectory()) {
	            throw new IllegalArgumentException("Not a valid directory path: " + folderPath);
	        }

	        File[] files = folder.listFiles();
	        if (files != null) {
	            for (File file : files) {
	                if (file.isFile()) {
	                    String fileName = file.getName();
	                    Image icon = createImageFromFile(file.getAbsolutePath(),display);
	                    iconMap.put(fileName, icon);
	                }
	            }
	        }
	    }
	    public ArrayList<String> loadNameAccessoireFromFolder(String folderPath,Display display,ArrayList<String>listnameaccessoire) {
	        File folder = new File(folderPath);
	        if (!folder.isDirectory()) {
	            throw new IllegalArgumentException("Not a valid directory path: " + folderPath);
	        }

	        File[] files = folder.listFiles();
	        if (files != null) {
	            for (File file : files) {
	                if (file.isFile()) {
	                    String fileName = file.getName().trim();
	                    listnameaccessoire.add(fileName);
	                }
	            }
	        }
			return listnameaccessoire;
	    }

	    private Image createImageFromFile(String filePath,Display display) {
	        ImageData imageData = new ImageData(filePath);
	        return new Image(display, imageData);
	    }

	    public Image getIcon(String fileName) {
	        return iconMap.get(fileName);
	    }

	    public void disposeAllIcons() {
	        iconMap.values().forEach(Image::dispose);
	        iconMap.clear();
	    }

		public Map<String, Image> getIconMap() {
			return iconMap;
		}

		public void setIconMap(Map<String, Image> iconMap) {
			this.iconMap = iconMap;
		}
	    
}

