package dressing.config;
import java.io.*;
import java.nio.file.*;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UnifiedLogger {

    private static final String LOG_DIR = WorkspaceConfiguration.getLogPath();
    private static final SimpleDateFormat FILE_DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat ENTRY_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static PrintStream sharedLog;

    public static void init() {
        try {
            Files.createDirectories(Paths.get(LOG_DIR));

            String today = FILE_DATE.format(new Date());
            File logFile = new File(LOG_DIR, "rcp-log-" + today + ".log");

            sharedLog = new PrintStream(new FileOutputStream(logFile, true), true);

            System.setOut(new PrintStream(new TimestampedOutputStream(sharedLog, false), true));
            System.setErr(new PrintStream(new TimestampedOutputStream(sharedLog, true), true));

            System.out.println("=== Logging started at " + ENTRY_DATE.format(new Date()) + " ===");

        } catch (IOException e) {
            e.printStackTrace(); // fallback to console if log file fails
        }
    }

    public static void close() {
        if (sharedLog != null) {
            sharedLog.flush();
            sharedLog.close();
        }
    }
}