package dressing.cam.model;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Tool;
import dressing.model.Cavity;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.cam.model.CamShape;
import dressing.cam.model.Cercle2D;
import dressing.cam.model.Cuboid;
import dressing.cam.model.Operation;

public class Usinage extends DesignObject3D{
	private List<Operation> operations =null;
	protected DesignObject3D mother=null;
	transient public CamShape shape=null;

	public Usinage() {
		super();
		this.operations=new ArrayList<Operation>();
	}

	public Usinage(Tool tool, List<Operation> operations) {
		super();
		this.operations = operations;
	}
	
	public DesignObject3D getMother() {
		return mother;
	}
	public void setMother(DesignObject3D mother) {
		DesignObject3D oldValue = this.mother;
		this.mother = mother;
		firePropertyChange("mother", oldValue, mother);
	}
	public List<Operation> getOperations() {
		if(operations==null) {
			this.operations = new ArrayList<Operation>();
		}
		return operations;
	}

	public void setOperations(List<Operation> operations) {
		List<Operation> oldValue = this.operations;
		this.operations = operations;
		firePropertyChange("operations", oldValue, operations);
	}
	
	public boolean addOperation(Operation operation) throws NullPointerException{
		return this.getOperations().add(operation);
	}
	
	
	public CamShape getShape() throws DesignException {
		if(shape==null)
		{
			if(this instanceof Trou) {
				shape= new Cercle2D((Trou) this, getprimaryPlan());
			}
			else if(this instanceof Rainure || this instanceof Cavity) {
				shape= new Cuboid(this, getprimaryPlan());
			}
		}
		return shape;
	}
	



	public void setShape(CamShape shape) {
		this.shape = shape;
	}

	@Override
	public double getXSize() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public double getYSize() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public double getZSize() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public BufferedImage getImage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		return false;
	}
	/**
	 * transformer le position de cette trou depuis la repert de mother vers la repert de parentDisign
	 */
	public void transformtoParentCords() {
		this.xpos=this.xpos-this.getParentdesign().getXPosABS() + this.getMother().getXPosABS();
		this.ypos=this.ypos-this.getParentdesign().getYPosABS() +this.getMother().getYPosABS();
		this.zpos=this.zpos-this.getParentdesign().getZPosABS() + this.getMother().getZPosABS();
	}
	/**
	 * cherche for the best plan for the designated Usinage to work on so every one will be treated one and only and avoid repeated work 
	 * and avoid action that can damage the machine
	 * @return
	 */
	public PlanUsinage getprimaryPlan() {
		List<PlanUsinage> plans=new ArrayList<PlanUsinage>();
		for(PlanUsinage plan:PlanUsinage.values()) {
			if(isSolid(plan)) {
				plans.add(plan);
			}
		}
		if(plans.size()==1) {
			return plans.get(0);
		}else if(plans.size()>1) {
			List<PlanUsinage> minimumPlans=new ArrayList<PlanUsinage>();
			for(PlanUsinage plan:plans) {
				if(minimumPlans.size()==0) {
					minimumPlans.add(plan);
				}
				else if(Cuboid.getDepth(this, plan)<Cuboid.getDepth(this, minimumPlans.get(0))) {
					minimumPlans.clear();
					minimumPlans.add(plan);
				}else if (Cuboid.getDepth(this, plan)==Cuboid.getDepth(this, minimumPlans.get(0))) {
					minimumPlans.add(plan);
				}
				
			}
			if(minimumPlans.size()==1) {
				return minimumPlans.get(0);
			}else if(minimumPlans.size()>1) {
				PlanUsinage chosenPlan=minimumPlans.get(0);
				for(PlanUsinage plan:minimumPlans) {
					if(plan.ordinal()<=chosenPlan.ordinal()) {
						chosenPlan=plan;
					}
				}
				return chosenPlan;
			}
		}
		return PlanUsinage.FRONT;
	}
	
	/**
	 * @author Imed 
	 * @Bug 0001710
	 * @param pl le plan de representation d'un piece2D
	 * @return tester si la rainure existe sur le plan spécifier ou non 
	 */
	public boolean isSolid(PlanUsinage pl) {
		switch (pl) {
		case FRONT:
			return getZpos() + getProfondeurext() == getParentdesign().getProfondeurext();
		case BACK:
			return getZpos() == 0;
		case RIGHT:
			return getXpos() + getLongeurext() == getParentdesign().getLongeurext();
		case LEFT:
			return getXpos() == 0;
		case DOWN:
			return getYpos() == 0;
		case TOP:
			return getYpos() + getHauteurext() == getParentdesign().getHauteurext();
		default:
			return false;
		}		
	}
	
	
	@Override
	public DesignObject3D clone() {
		Usinage space=new Usinage();
		try {
			space=(Usinage) this.copy(space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Usinage usin =(Usinage) object;

		usin.setParentdesign(getParentdesign());
		 usin.setLongeurext(getLongeurext());
		 usin.setLongeurextfree(isLongeurextfree());
		 usin.setProfondeurext(getProfondeurext());
		 usin.setProfondeurextfree(isProfondeurextfree());
		 usin.setHauteurext(getHauteurext());
		 usin.setHauteurextfree(isHauteurextfree());
		 usin.setLongeurint(getLongeurint());
		 usin.setProfondeurint(getProfondeurint());
		 usin.setHauteurint(getHauteurint());
		 usin.setName(getName());
		 usin.setBasematerial(getBasematerial());
		 usin.setBasematerialfree(isBasematerialfree());
		 usin.setBackmaterial(getBackmaterial());
		 usin.setBackmaterialfree(isBackmaterialfree());
		 usin.setFacadeMaterial(getFacadeMaterial());
		 usin.setFacadematerialfree(isFacadematerialfree());
		 usin.setXpos(getXpos());
		 usin.setYpos(getYpos());
		 usin.setZpos(getZpos());
		 usin.setXPosABS(getXPosABS());
		 usin.setYPosABS(getYPosABS());
		 usin.setZPosABS(getZPosABS());
		 usin.setProps(getProps());
		 usin.systemesequations=this.systemesequations;
		 usin.systemesequationsasparent=this.systemesequationsasparent;
		 usin.setID(getID());
		 List<Operation> opps=copyOperations();
		 usin.setMother(getMother());
		 for(Operation op:opps) {
			 op.setUsin(usin);
		 }
		 usin.setOperations(opps);
		 
		 for(DesignObject3D design:getChilds() ) {
			 usin.addElement(design.clone());			
		 }
		return usin;
	}
	
	public List<Operation> copyOperations(){
		List<Operation> ops=new ArrayList<Operation>();
		for(Operation op : this.operations)
		{
			try {
				ops.add( op.clone());
			} catch (CloneNotSupportedException e) {
				e.printStackTrace();
			}
		}
		return ops;
	}
	
	
	public ArrayList<Vector3> getCorners() {
		float width = (float)getLongeurext();
		float height = (float)getHauteurext();
		float depth = (float) getProfondeurext();
		Vector3 halfDims = new Vector3(width, height, depth).scl(0.5f);
		Vector3 origin = new Vector3((float)getXpos(), (float)getYpos(), (float) getZpos()).add(halfDims);
		ArrayList<Vector3> corners = new ArrayList<Vector3>();
		corners.add(origin.cpy().add(halfDims.cpy().scl(1,1,1)));
		corners.add(origin.cpy().add(halfDims.cpy().scl(1,1,-1)));
		corners.add(origin.cpy().add(halfDims.cpy().scl(1,-1,1)));
		corners.add(origin.cpy().add(halfDims.cpy().scl(1,-1,-1)));
		corners.add(origin.cpy().add(halfDims.cpy().scl(-1,1,1)));
		corners.add(origin.cpy().add(halfDims.cpy().scl(-1,1,-1)));
		corners.add(origin.cpy().add(halfDims.cpy().scl(-1,-1,1)));
		corners.add(origin.cpy().add(halfDims.cpy().scl(-1,-1,-1)));
		return corners;
	}
	
	public void setPosition(Vector3 position) {
		setXpos(position.x);
		setYpos(position.y);
		setZpos(position.z);
		
	}

	public void setSize(Vector3 dims) {
		setLongeurext(dims.x);
		setHauteurext(dims.y);
		setProfondeurext(dims.z);
	}

	public void feetpiece(Vector2 translation) {
		if(this instanceof Trou)  {
			((Trou)this).setXcenter(this.getXpos()+translation.x);
			((Trou)this).setYcenter(this.getYpos()+translation.y);
			
		}
//		setXpos(this.getXpos()+translation.x);
//		setYpos(this.getXpos()+translation.y);
	}
}
