package dressing.cam.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

import com.badlogic.gdx.math.Vector3;

import dressing.model.Piece2D;
import param.cam.MachineHead;
import param.cam.MachineSides;
import param.Tool;

import java.nio.file.Paths;

public class GriggioCodeGenerator extends GcodeGeneratorImp implements GcodeGenerator {

	public final String N = System.getProperty("line.separator");
    public static GriggioCodeGenerator instance;
	public static GriggioCodeGenerator getInstance() {
 		synchronized(GriggioCodeGenerator.class) {
 			if (instance == null) {
 				instance = new GriggioCodeGenerator();
 			}
 			return instance;
 		}
	}
	
	public String generateHoleBlock(Tool tool, int face, Vector3 start, Vector3 end, int depth) {
		String block ;
		if(face==1)
		{
			block = "W#81{ ::WTp WS=@Number@  #8015=0 "+"#1="+start.x+" #2="+start.y+" #3="+-depth+" #1002=8 #201=1 #203=1 #205="+tool.getCode()+" #1001=0 }W"+N;
		}else {
			Vector3 pos=start.cpy();
			switch (face) {
			case 3:
				pos.x=start.x;
				pos.y=start.z;
				break;
			case 4:
				pos.x=start.y;
				pos.y=start.z;
				break;
			case 5:
				pos.x=end.x-start.x;
				pos.y=start.z;
				break;
			case 6:
				pos.x=start.y;
				pos.y=start.z;

				break;
			default:
				break;
			}
			block = "W#81{ ::WTp WS=@Number@  #8015=0 #1="+pos.x+" #2="+pos.y+" #3="+(-depth)+" #201=1 #203=1 #205="+tool.getCode()+" #1001=0 }W"+N;
		}
        return  block;
	}
	@Override
	public String generateHeader(Vector3 point) {
		String header = "::UNm DL=" +((int) point.x) + " DH="+ ((int)point.y)+ " DS=" + ((int)point.z) + N;
		
		return header;
	}
	
	public String generaterRainureBlock(Tool tool, int face, Vector3 start, Vector3 end, int depth) {
		String block="W#89{ ::WTs WS=@Number@  #8015=0 #1="+start.x+" #2="+start.y+" #3="+(-depth)+" #201=1 #203=1 #205="+tool.getCode()+" #1001=100 #8101=0 #8096=0 #40=0 #8135=0 #8136=0 #8180=0 #8181=0 #8185=0 #8186=0 }W"+N;
		block+="W#2201{ ::WTl  #8015=0 "+(start.x!=end.x?("#1="+end.x):"#2="+end.y)+" #42=0 }W"+N;
		
       //System.err.println(block);
        return  block;
	}
	
	//face 100
	
	public String generaterRectangulaireFreizeBlock(Tool tool,int face,  Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4,
			Vector3 piece, int depth, float cutterRadius) {
        String block = "";
        //block-1
         if(point1.y > 0) {
			//
			float x1 = point1.x;
			float x2 = point2.x;
			float y = point1.y;
			if (x1 != 0) {
				x1 += cutterRadius;
			}
			if (x2 != piece.x) {
				x2 -= cutterRadius;
			}
			y += cutterRadius;
			//
              String dd=  generaterRainureBlock(tool, face, new Vector3(x1, y, piece.z), new Vector3(x2, y, piece.z), depth);
              block+=dd;//operatioLine+f+block_1+endblock_1;
         }
       
         //block-2
         if(point2.x < piece.x ){
			//
			float y1 = point2.y;
			float y2 = point3.y;
			float x = point2.x;
			if (y1 != 0) {
				y1 += cutterRadius;
			}
			if (y2 != piece.y) {
				y2 -= cutterRadius;
			}
			x -= cutterRadius;
			//
             String dd=  generaterRainureBlock(tool, face, new Vector3(x, y1, piece.z), new Vector3(x, y2, piece.z), depth);

             block+=dd;//operatioLine+f+block_2+endblock_2;
         }
         
         //block-3
         if(point3.y < piece.y) {
        	 //
 			float x1 = point3.x;
 			float x2 = point4.x;
 			float y = point3.y;
 			if (x1 != piece.x) {
 				x1 -= cutterRadius;
 			}
 			if (x2 != 0) {
 				x2 += cutterRadius;
 			}
 			y -= cutterRadius;
 			//
              String dd=  generaterRainureBlock(tool, face, new Vector3(x1, y, piece.z), new Vector3(x2, y, piece.z), depth);

              block+=dd;//operatioLine+f+block_3+endblock_3;
         }
       
         //block-4
         if(point4.x > 0) {
     		//
 			float y1 = point4.y;
 			float y2 = point1.y;
 			float x = point4.x;
 			if (y1 != piece.y) {
 				y1 -= cutterRadius;
 			}
 			if (y2 != 0) {
 				y2 += cutterRadius;
 			}
 			x += cutterRadius;
 			//
             String dd=  generaterRainureBlock(tool, face, new Vector3(x, y1, piece.z), new Vector3(x, y2, piece.z), depth);

             block+=dd;//operatioLine+f+block_4+endblock_4; 
         }
       // System.err.println(block);
        return  block;
	}
	  private static String readLineByLineJava8(String filePath) 
	    {
	        StringBuilder contentBuilder = new StringBuilder();
	 
	        try (Stream<String> stream = Files.lines( Paths.get(filePath), StandardCharsets.UTF_8)) 
	        {
	            stream.forEach(s -> contentBuilder.append(s).append("\n"));
	        }
	        catch (IOException e) 
	        {
	            e.printStackTrace();
	        }
	 
	        return contentBuilder.toString();
	    }
	private String codeTemplate() {
		Bundle bundle = Platform.getBundle("Dressing");
		String content="";
		org.eclipse.core.runtime.Path path = new org.eclipse.core.runtime.Path("src/dressing/cam/model/machine.txt");
		try { 
			URL url = FileLocator.find(bundle, path, null);
			URL fileURL = FileLocator.toFileURL(url);
			File file=new File(fileURL.getFile());
			content = new String(Files.readAllBytes(Paths.get(file.getPath())));
		} catch (IOException  e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return content;
	}
	public Map<String, String> generateCode(Piece2D piece) {
//		Map<String, String> gcodes=new HashMap<String, String>();
//		String facetemplate=codeTemplate();
//		String backtemplate=codeTemplate();
//		SystemCoordinateSwitcher scs = new SystemCoordinateSwitcher();
//		scs.init(piece);
//		List<Trou> trouList = piece.getTrous();
//		List<Usinage> cavities = piece.getCavities();
//		
//		ArrayList<Operation> trouOperations = new ArrayList<Operation>();
//		for(Trou trou: trouList) {
//			trouOperations.addAll(trou.getOperations());
//		}
//		Map<Tool,List<Operation>> layers = new HashMap<Tool, List<Operation>>();
//		
//		for(Operation operation: trouOperations) {
//			Tool tool = operation.getTool();
//			List<Operation> toolsOperations;
//			if(layers.containsKey(tool)) {
//				 toolsOperations = layers.get(tool);
//			}else {
//				toolsOperations = new ArrayList<Operation>();
//				layers.put(tool, toolsOperations);
//			}
//			toolsOperations.add(operation);
//		}
//		ArrayList<Operation> sortedOperations = new ArrayList<Operation>();
// 		for(Usinage cavity: cavities) {
// 			sortedOperations.addAll(cavity.getOperations());
// 		}
//		
//		for(Tool tool: layers.keySet()) {
//			Util.sortOps(layers.get(tool));
//			sortedOperations.addAll(layers.get(tool));
//		}
//		
//		
//		Vector3 dimension = CoordinateSystem.getPieceDimension(piece);
//		
//		float length = dimension.x;
//		float depth = dimension.z;
//		float width = dimension.y;
//		Vector3 vector;
//		switch (piece.getPieceOrientation()) {
//		case VERTICAL:
//			vector = Vector3.X;
//			break;
//		case HORIZONTAL:
//			vector = Vector3.Y;
//		break;
//		case PROUFOUND:
//			vector = Vector3.Z;
//			break;
//		default:
//			vector = Vector3.Z;
//			break;
//		}
//		Vector3 dim= new Vector3(length,width,depth);
//		String header = generateHeader(dim);
//		facetemplate =facetemplate.replaceAll("@header@", header);
//		backtemplate =backtemplate.replace("@header@", header);
//
//		String face1="";
//		String face3="";
//		String face4="";
//		String face5="";
//		String face6="";
//		String back1="";
//		String back3="";
//		String back4="";
//		String back5="";
//		String back6="";
//		String gcodeRainure="";
//		String gcodeBackRainure="";
//		String extrusion="";
//		String extrusionback="";
//		for (Operation op : sortedOperations) {
//				Tool tool = op.getTool();
//					Usinage usin = op.getUsin();
//					if (usin instanceof Trou) {
//						Trou cercle = (Trou) usin;
//						Vector3 start = scs.toMachineCoordinate(cercle.getStart());
//						Vector3 end = scs.toMachineCoordinate(cercle.getEnd());
//						MachineSides face=getTrouface(start, end);
//						MachineHead head = getMachineHead(usin, face);
//						int side1 =getsidecode(face);
//						param.cam.Tool opTool = getTool((Trou) usin, head, face);
//						if(opTool!=null) {
//							double cheek = getCheek(cercle,piece.getPieceOrientation(),piece);
//							if (cheek == 0) {
//								start.x = length - start.x;
//								face1+=generateHoleBlock(opTool.getCode(), side1, start, dim,
//											(int) cercle.getDepth());
//								
//							}
//							if(cheek == 1) {
//								back1 += generateHoleBlock(opTool.getCode(), side1, start, dim,
//										(int) cercle.getDepth());
//							}
//							if(cheek == 100) {
//								
//								String trouface= generateHoleBlock(opTool.getCode(), side1, start, dim,
//										(int) cercle.getDepth());
//								start.x=length-start.x;
//								end.x=length-end.x;
//								face=getTrouface(start, end);
//								int side2=getsidecode(face);
//								head = getMachineHead(usin, face);
//								opTool = getTool((Trou) usin, head, face);
//								String trouback = generateHoleBlock(opTool.getCode(), side2, start, dim,
//										(int) cercle.getDepth());
//								switch (side1) {
//								case 3:
//									face3+=trouface;
//									break;
//								case 4:
//									face4+=trouface;
//									break;
//								case 5:
//									face5+=trouface;
//									break;
//								case 6:
//									face6+=trouface;
//									break;
//								default:
//									break;
//								}
//								switch (side2) {
//								case 3:
//									back3+=trouback;
//
//									break;
//								case 4:
//									back4+=trouback;
//
//									break;
//								case 5:
//									back5+=trouback;
//
//									break;
//								case 6:
//									back6+=trouback;
//
//									break;
//								default:
//									break;
//								}
//							}
//							
//						}
//						
//					} else {
//						if (op.getUsin() instanceof Rainure) {
//							 
//							Rainure rainure = (Rainure) op.getUsin();
//
//							float depthR = vector.dot(new Vector3((float)rainure.getLongeurext(), (float)rainure.getHauteurext(), (float) rainure.getProfondeurext())); 
//							double distance = Math.max(Math.max(rainure.getLongeurext(), rainure.getHauteurext()),
//									rainure.getProfondeurext());
//							Vector3 start = new Vector3((float)rainure.getXpos(),(float) rainure.getYpos(),(float) rainure.getZpos());
//							Vector3 end = new Vector3((float)rainure.getXpos(), (float)rainure.getYpos() ,(float)rainure.getZpos());
//							if (distance == rainure.getLongeurext()) {
//								start.z += rainure.getProfondeurext()/2;
//								end.x += distance;
//								end.y = start.y;
//								end.z = start.z;
//							} else if (distance == rainure.getHauteurext()) {
//								if(start.x == 0) {
//									start.x += rainure.getLongeurext();
//								}
//								//test if the piece is profondeur and rainure move on the axe Y 
//								//we move the axe X to be in the middle of the width of the rainure
//								//and otherwise meaning the piece is vertical we move the axe X to be in the middle of the width of the rainure
//								if(vector==Vector3.Z) {
//									start.x += rainure.getLongeurext() / 2;
//									end.y += distance;
//									end.x = start.x;
//									end.z = start.z;
//								}else {
//									start.z += rainure.getProfondeurext() / 2;
//									end.y += distance;
//									end.x = start.x;
//									end.z = start.z;
//								}
//								
//							} else {
//								start.x += rainure.getLongeurext() / 2;
//								end.z += distance;
//								end.x = start.x;
//								end.y = start.y;
//							}
//							Vector3 startX = scs.toMachineCoordinate(start);
//							Vector3 endX = scs.toMachineCoordinate(end);
//							if(startX.x > endX.x) {
//								Vector3 bucket = startX;
//								startX = endX;
//								endX = bucket;
//							}
//							startX.z = depth;
////							if(flip) {
////								endX.z *= -1;
////								endX.z += depth;
////							}
//							int face=6;
//							if(startX.x==endX.x) {
//								face=1;
//							}
//							endX.z=depth-depthR;
//							int cheek = getCheek(rainure, piece.getPieceOrientation(), piece);
////							if(face==6)//ne pas passer le rainure si son axe est diffirent du X
////							{
//								if(cheek == 0) 
//								{	
//									if(vector==Vector3.Z||vector==Vector3.X) {
//										startX.x=length-startX.x;
//										endX.x=length-endX.x;
//										if(startX.x > endX.x) {
//											Vector3 bucket = startX;
//											startX = endX;
//											endX = bucket;
//										}
//										startX.z = depth;
//										endX.z=depth-depthR;
//									}									
//									gcodeRainure += generaterRainureBlock(tool, face, startX, endX, -1);
//								}
//								if (cheek == 1)
//								{
//									if(vector==Vector3.Y) {
//										startX.x=length-startX.x;
//										endX.x=length-endX.x;
//										if(startX.x > endX.x) {
//											Vector3 bucket = startX;
//											startX = endX;
//											endX = bucket;
//										}
//										startX.z = depth;
//										endX.z=depth-depthR;
//									}	
//									gcodeBackRainure += generaterRainureBlock(tool.getCode(), face, startX, endX, -1);	
//								}
////							}
//							
//							
//						} else {
//
//							Cuboid cubeD = (Cuboid) op.getShape();
//							Usinage cube = cubeD.getCube();
//							int cavityDepth = (int) vector.dot(new Vector3((float)cube.getLongeurext(), (float)cube.getHauteurext(), (float) cube.getProfondeurext())); 
//
//							Vector3 vertice000 = new Vector3((float)cube.getXpos(), (float)cube.getYpos(),(float) cube.getZpos());
//							Vector3 vertice001 = new Vector3((float)cube.getXpos(),(float) cube.getYpos(),(float)
//									cube.getZpos() + (float)cube.getProfondeurext());
//							Vector3 vertice010 = new Vector3((float)cube.getXpos(),(float) cube.getYpos() + (float)cube.getHauteurext(),
//									(float)cube.getZpos());
//							Vector3 vertice011 = new Vector3((float)cube.getXpos(), (float)cube.getYpos() +(float) cube.getHauteurext(),
//									(float)cube.getZpos() + (float)cube.getProfondeurext());
//							Vector3 vertice100 = new Vector3((float)cube.getXpos() + (float)cube.getLongeurext(), (float)cube.getYpos(),
//									(float)cube.getZpos());
//							Vector3 vertice101 = new Vector3((float)cube.getXpos() + (float)cube.getLongeurext(), (float)cube.getYpos(),
//									(float)cube.getZpos() + (float)cube.getProfondeurext());
//							Vector3 vertice110 = new Vector3((float)cube.getXpos() +(float) cube.getLongeurext(),
//									(float)cube.getYpos() +(float) cube.getHauteurext(),(float) cube.getZpos());
//							Vector3 vertice111 = new Vector3((float)cube.getXpos() + (float)cube.getLongeurext(),
//									(float)cube.getYpos() +(float) cube.getHauteurext(),(float) cube.getZpos() + (float)cube.getProfondeurext());
//							vertice000 = scs.toMachineCoordinate(vertice000);
//							vertice001 = scs.toMachineCoordinate(vertice001);
//							vertice010 = scs.toMachineCoordinate(vertice010);
//							vertice011 = scs.toMachineCoordinate(vertice011);
//							vertice100 = scs.toMachineCoordinate(vertice100);
//							vertice101 = scs.toMachineCoordinate(vertice101);
//							vertice110 = scs.toMachineCoordinate(vertice110);
//							vertice111 = scs.toMachineCoordinate(vertice111);
//							ArrayList<Vector3> vertices = new ArrayList<Vector3>();
//							vertices.add(vertice111);
//							vertices.add(vertice110);
//							vertices.add(vertice101);
//							vertices.add(vertice100);
//							vertices.add(vertice011);
//							vertices.add(vertice010);
//							vertices.add(vertice001);
//							vertices.add(vertice000);
//							int j = 0;
//							ArrayList<Vector3> verticesToConsider = new ArrayList<Vector3>();
//							while (verticesToConsider.size() < 4) {
//								for (int i = j; i < vertices.size(); i++) {
//									if (vertices.get(i) == vertices.get(j)
//											|| verticesToConsider.contains(vertices.get(i)))
//										continue;
//									if (vertices.get(i).x == vertices.get(j).x && vertices.get(i).y == vertices.get(j).y)
//										verticesToConsider.add(vertices.get(i));
//								}
//								j++;
//							}
//							String gcodeExtrusion1="";
//							String gcodeExtrusion2="";
//							Vector3[] points = sortVertices(verticesToConsider, dimension);
//							int face =100;
//							gcodeExtrusion1 += generaterRectangulaireFreizeBlock(tool.getCode(),face, points[0], points[1],
//									points[2], points[3], dimension, cavityDepth, (float)tool.getCutter_diameter() / 2f);
//							for(Vector3 v:verticesToConsider) {
//								v.x=length-v.x;
//								
//							}
//							points = sortVertices(verticesToConsider, dimension);
//
//							gcodeExtrusion2 += generaterRectangulaireFreizeBlock(tool.getCode(),face, points[0], points[1],
//									points[2], points[3], dimension, cavityDepth, (float)tool.getCutter_diameter() / 2f);
//							if(vector==Vector3.Z||vector==Vector3.X) {
//								extrusionback+=gcodeExtrusion1;
//								extrusion+=gcodeExtrusion2;
//							}else {
//								extrusionback+=gcodeExtrusion2;
//								extrusion+=gcodeExtrusion1;
//							}
//						}
//					}
////					
//					
//		}
//		boolean lateralAdded = false;
//		face1+=gcodeRainure;
//		back1+=gcodeBackRainure;
//		
//		if (!face1.isEmpty()) {
//			String code=facetemplate;
//			String sides="1;";
//
//			if(!piece.getPiecetype().equals(PieceType.BAS_CUISSON)&&!face1.isEmpty()&& back1.isEmpty()) {
//				code=code.replace("@side3@", face3);
//				code=code.replace("@side4@", face4);
//				code=code.replace("@side5@", face5);
//				code=code.replace("@side6@", face6);
//				if(!face3.isEmpty()) {
//					sides+="3;";
//				}
//				if(!face4.isEmpty()) {
//					sides+="4;";
//				}
//				if(!face5.isEmpty()) {
//					sides+="5;";
//				}
//				if(!face6.isEmpty()) {
//					sides+="6;";
//				}
//				if(extrusion!=null && !extrusion.isEmpty()) {
//					face1+=extrusion;
//				}
//				lateralAdded = true;
//			}
//			code=code.replace("@side1@", face1);
//			code=code.replace("@Sides@", sides);
//			code=fixIndex(code);
//			gcodes.put("face", code);	
//		}
//		if (!back1.isEmpty()) {
//			String code=facetemplate;
//			String sides="1;";
//
//			if(!lateralAdded) {		
//				code=code.replace("@side3@", back3);
//				code=code.replace("@side4@", back4);
//				code=code.replace("@side5@", back5);
//				code=code.replace("@side6@", back6);
//				if(!back3.isEmpty()) {
//					sides+="3;";
//				}
//				if(!back4.isEmpty()) {
//					sides+="4;";
//				}
//				if(!back5.isEmpty()) {
//					sides+="5;";
//				}
//				if(!back6.isEmpty()) {
//					sides+="6;";
//				}
//				if(extrusionback!=null && !extrusionback.isEmpty()) {
//					back1+=extrusionback;
//				}
//				lateralAdded = true;
//			}
//			code=code.replace("@side1@", back1);
//			code=code.replace("@Sides@", sides);
//			code=fixIndex(code);
//			gcodes.put("back", code);
//		}
//		if(!lateralAdded && (!face3.isEmpty()|| !face4.isEmpty()||!face5.isEmpty()|| !face6.isEmpty()||!extrusion.isEmpty())){
//			String code=facetemplate;
//			if(extrusion!=null && !extrusion.isEmpty()) {
//				face1+=extrusion;
//			}
//			code=code.replace("@side1@", face1);
//			code=code.replace("@side3@", face3);
//			code=code.replace("@side4@", face4);
//			code=code.replace("@side5@", face5);
//			code=code.replace("@side6@", face6);
//			String sides="";
//			if(!face3.isEmpty()) {
//				sides+="3;";
//			}
//			if(!face4.isEmpty()) {
//				sides+="4;";
//			}
//			if(!face5.isEmpty()) {
//				sides+="5;";
//			}
//			if(!face6.isEmpty()) {
//				sides+="6;";
//			}
//			code=code.replace("@Sides@", sides);
//			code=fixIndex(code);
//			gcodes.put("face", code);	
//			lateralAdded = true;
//
//		}
//		return gcodes;
		return new HashMap<String, String>();
	}
	private String fixIndex(String template) {
		int index=1;
		while(template.contains("@Number@")) {
			template=template.replaceFirst("@Number@", String.valueOf(index));
			index++;
		}
		return template;
	}
	
	private int getsidecode(MachineSides sides) {
		switch (sides) {
		case BOTTOM:

			return 3;
		case TOP:

			return 5;
		case LEFT:
			return 4;

		case RIGHT:

			return 6;
		default:
			return 1;

		}
	}
	@Override
	public String generateHoleBlock(Tool tool, MachineHead head, Vector3 start, Vector3 end, int depth) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String generaterRainureBlock(Tool tool, MachineHead head, Vector3 start, Vector3 end, int depth) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String generaterRectangulaireFreizeBlock(Tool tool, MachineHead head, Vector3 point1, Vector3 point2,
			Vector3 point3, Vector3 point4, Vector3 piece, int depth, float cutterRadius) {
		// TODO Auto-generated method stub
		return null;
	}
}
