package dressing.cam.model;

import java.util.ArrayList;

import org.frs.debitage.cam.dxf.model.DXF_STATIC_VALUE;
import org.frs.debitage.cam.dxf.model.Rotationangle;
import org.frs.debitage.cam.graphunit.PCircleDXFEntity2;
import org.frs.debitage.cam.graphunit.PLineDXFEntity;
import org.frs.debitage.cam.graphunit.PointDXF;
import org.frs.debitage.cam.graphunit.PolyLineDXFEntity;

import com.badlogic.gdx.math.Vector3;

import dressing.config.ReportingPreferences;
import dressing.model.Cavity;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;


public class DXFUtils {

	
	public static String getDXFLineEntetity(PlanUsinage persp ,Piece2D piece) {
		return getDXFLineEntetity(persp, false, piece);
	}

	public static String getDXFLineEntetity(PlanUsinage persp, boolean ishowLateral,Piece2D piece) {
		return getDXFLineEntetity(persp, ishowLateral, Rotationangle.angleRotation0, false, piece);
	}

	public static String getDXFLineEntetity(PlanUsinage persp, boolean ishowLateral, Rotationangle Rotationangle,
			boolean isRotatePiece,Piece2D piece) {
		if (isRotatePiece) {
			for (DesignObject3D des : piece.getChilds()) {
				if (des instanceof Rainure) {
					Rainure rainure = (Rainure) des;
					Rotationangle = testerAngleRotation(rainure, persp, Rotationangle);
					break;
				} else
					continue;

			}
		}

		float width = (float) Util.getDesignWidth(piece,persp);
		float height = (float) Util.getDesignHeight(piece,persp);

		String s = "";
		PLineDXFEntity line1 = null;
		PLineDXFEntity line2 = null;
		PLineDXFEntity line3 = null;
		PLineDXFEntity line4 = null;
		PointDXF origin = new PointDXF(0, 0);

		// ligne 1
		PointDXF p1 = origin.getLocation();
		PointDXF p2 = p1.getLocation();
		p2.x += width;

		// ligne2
		PointDXF p3 = p2.getLocation();
		p3.y += height;

		// ligne 3
		PointDXF p4 = p1.getLocation();
		p4.y += height;

		if (DXF_STATIC_VALUE.USE_POLYLINE == false) {
			line1 = new PLineDXFEntity(p1, p2);
			line2 = new PLineDXFEntity(p2, p3);
			line3 = new PLineDXFEntity(p1, p4);
			line4 = new PLineDXFEntity(p4, p3);

			// Create String seintity
			s += line1.getDXFLineEntetity();
			s += line2.getDXFLineEntetity();
			s += line3.getDXFLineEntetity();
			s += line4.getDXFLineEntetity();
		} else {
			PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
			poly.addVertices(p1);
			poly.addVertices(p2);
			poly.addVertices(p3);
			poly.addVertices(p4);
			poly.addVertices(p1);

			s += poly.getDXFEntity(Rotationangle);

		}
		ArrayList<Rainure> listRainure = new ArrayList<Rainure>();

		for (DesignObject3D des : piece.getChilds()) {

			if (des instanceof Trou) {
				Trou tr = (Trou) des;
				if (tr.isSolid(persp)) {
					s += DXFUtils.getDXFLineEntetity(persp, piece, Rotationangle,tr);
				}
				if (tr.isLateral(persp) && ishowLateral) {
					s += DXFUtils.getDXFLineEntetityLateral(persp, piece, Rotationangle,tr);
				}
				// Imed bug 0001710 ajouter les rainure dans l'exportation dxf
			} else if (des instanceof Rainure) {
				Rainure rn = (Rainure) des;
				if (rn.isSolid(persp)) {
					// le cas assemblerainure true on vas collecter dans la listrainure les rainure
					// de piece et le traiter par la methode getDXFLineEntetityassemble.
					if (ReportingPreferences.getInstance().getProperty("DXF.AssembleRainure", true)) {
						listRainure.add(rn);
					} else {

						s += DXFUtils.getDXFLineEntetity(persp, Rotationangle,rn);
					}
				}
			} else if (des instanceof Cavity) {
				Cavity rn = (Cavity) des;
				if (rn.isSolid(persp)) {
					s += DXFUtils.getDXFLineEntetity(persp, Rotationangle,rn);
				}
			}

		}
		if (listRainure.size() > 0) {
			s += DXFUtils.getDXFLineEntetityassemble(persp, listRainure, piece, Rotationangle);

		}

		return s;
	}

	private static Rotationangle testerAngleRotation(Rainure rainure, PlanUsinage persp,Rotationangle angledeRotation) {
		Piece2D parentpiece;
		parentpiece=(Piece2D) rainure.getParentdesign();
		Double largeur = Util.getDesignWidth(parentpiece,persp);
		Double hauteur = Util.getDesignHeight(parentpiece,persp);
		PointDXF p = DXFUtils.getOrigin(persp, parentpiece,rainure);
		Double X=(double) p.x;
		Double Y=(double) p.y;
			if(angledeRotation.equals(Rotationangle.angleRotation90)) {
			
				if (X>0.5*largeur) {
					return Rotationangle.angleRotationMoin90;
				}else
				{
				return Rotationangle.angleRotation90;
				}
			}
			else {
				if (Y<0.5*hauteur) {
					return Rotationangle.angleRotation180;
				}
				else
				{
				return Rotationangle.angleRotation0;
				}
			}
			
		}

	
	
	/**
	 * @author Imed
	 * @Bug 0001710
	 * @param pl le plan de representation d'un piece2D
	 * @return retourne la point d'origine de ce rainure sur le plan spécifier
	 */
	public static PointDXF getOrigin(PlanUsinage persp, Piece2D piece2d, Usinage usin) {
		PointDXF centre = new PointDXF(0, 0);
		float width = (float) Util.getDesignWidth(piece2d,persp);
		float height = (float) Util.getDesignHeight(piece2d,persp);

		switch (persp) {
		case FRONT:
			centre.x = (float) usin.getXpos();
			centre.y = (float) usin.getYpos();
			break;
		case BACK:
			centre.x = (float) (width - usin.getXpos() - usin.getLongeurext());
			centre.y = (float) usin.getYpos();
			break;

		case RIGHT:
			centre.x = (float) (width - usin.getZpos() - usin.getProfondeurext());
			centre.y = (float) usin.getYpos();
			break;
		case LEFT:
			centre.x = (float) (usin.getZpos());
			centre.y = (float) usin.getYpos();
			break;
		case DOWN:
			centre.x = (float) usin.getXpos();
			centre.y = (float) usin.getZpos();
			break;
		case TOP:
			centre.x = (float) usin.getXpos();
			centre.y = (float) (height - usin.getZpos() - usin.getProfondeurext());
			break;
		default:
			break;
		}
		return centre;
	}

	public static String getDXFLineEntetity(PlanUsinage persp, Rotationangle anglerotation, Usinage usin) {
		float width = (float) Util.getDesignWidth(usin, persp);
		float height = (float) Util.getDesignHeight(usin, persp);

		String s = "";
		PLineDXFEntity line1 = null;
		PLineDXFEntity line2 = null;
		PLineDXFEntity line3 = null;
		PLineDXFEntity line4 = null;
		PointDXF origin = DXFUtils.getOrigin(persp, (Piece2D) usin.getParentdesign(), usin);

		// ligne 1
		PointDXF p1 = origin.getLocation();
		PointDXF p2 = p1.getLocation();
		p2.x += width;

		// ligne2
		PointDXF p3 = p2.getLocation();
		p3.y += height;

		// ligne 3
		PointDXF p4 = p1.getLocation();
		p4.y += height;

		if (DXF_STATIC_VALUE.USE_POLYLINE == false) {
			line1 = new PLineDXFEntity(p1, p2);
			line2 = new PLineDXFEntity(p2, p3);
			line3 = new PLineDXFEntity(p1, p4);
			line4 = new PLineDXFEntity(p4, p3);

			// Create String seintity
			s += line1.getDXFLineEntetity();
			s += line2.getDXFLineEntetity();
			s += line3.getDXFLineEntetity();
			s += line4.getDXFLineEntetity();
		} else {
			PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
			poly.addVertices(p1);
			poly.addVertices(p2);
			poly.addVertices(p3);
			poly.addVertices(p4);
			poly.addVertices(p1);
			s += poly.getDXFEntity(anglerotation);
		}
		return s;
	}

	/**
	 * @author Imed
	 * @Bug 0001710
	 * @param pl le plan de representation d'un piece2D
	 * @return retourne la dxf represente le rainure actuelle sur le plan spécifier
	 */
	public static String getDXFLineEntetityassemble(PlanUsinage persp, ArrayList<Rainure> listrainure1,
			Piece2D parentpiece, Rotationangle anglerotation) {
		ArrayList<PLineDXFEntity> listRainure = new ArrayList<PLineDXFEntity>();
		PointDXF p1 = new PointDXF();
		PointDXF p2 = new PointDXF();
		PointDXF p3 = new PointDXF();
		PointDXF p4 = new PointDXF();

		float epaisseur = 0;

		ArrayList<PLineDXFEntity> listdxflineaGenerer = new ArrayList<PLineDXFEntity>();
		ArrayList<PLineDXFEntity> listdxfsameaxeX = new ArrayList<PLineDXFEntity>();
		ArrayList<PLineDXFEntity> listdxfsameaxeY = new ArrayList<PLineDXFEntity>();
		for (Rainure rn : listrainure1) {
			float width = (float) Util.getDesignWidth(rn, persp);
			float height = (float) Util.getDesignHeight(rn, persp);

			epaisseur = Math.min(height, width);

			PointDXF origin = DXFUtils.getOrigin(persp, parentpiece, rn);

			// ligne 1
			if (height < width) {
				p1 = origin.getLocation();
				p2 = p1.getLocation();
				p2.x += width;

				// ligne2
				p3 = p2.getLocation();
				p3.y += height;

				// ligne 3
				p4 = p1.getLocation();
				p4.y += height;

			}
			if (width < height) {
				p1 = origin.getLocation();
				p2 = p1.getLocation();
				p2.y += height;

				// ligne2
				p3 = p2.getLocation();
				p3.x += width;

				// ligne 3
				p4 = p1.getLocation();
				p4.x += width;

			}
// on represent les rainure par des demi ligne passant par l'axe de rainure 
			PointDXF pstart = new PointDXF();
			PointDXF pend = new PointDXF();
			PLineDXFEntity axerainure = new PLineDXFEntity(pstart, pend);
			if (Util.epsilonEquals(p1.x, p4.x, 0.1f)) {
				pstart = p1.getLocation();
				float y = Math.min(height / 2, width / 2);
				pstart.y += y;

				pend = p3.getLocation();
				pend.y = pstart.y;
				axerainure = new PLineDXFEntity(pstart, pend);
				listRainure.add(axerainure);
			}
			if (Util.epsilonEquals(p1.y, p4.y, 0.1f)) {
				pstart = p1.getLocation();
				float x = Math.min(width / 2, height / 2);
				pstart.x += x;

				pend = p3.getLocation();
				pend.x = pstart.x;
				axerainure = new PLineDXFEntity(pstart, pend);
				listRainure.add(axerainure);
			}
		}
		String s = "";
		listdxflineaGenerer = testingAdjacentRainurefixed(listRainure, listdxfsameaxeX, listdxfsameaxeY);
		if (listdxflineaGenerer != null) {
			for (PLineDXFEntity line : listdxflineaGenerer) {
				PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
				if (ReportingPreferences.getInstance().getProperty("DXF.VueRainureLine", true)) {

					poly.addVertices(line.Satrtpoint);
					poly.addVertices(line.EndPoint);
					poly.addVertices(line.Satrtpoint);
					s += poly.getDXFEntity(anglerotation);
				} else {
					// pour créer un rainure rectangle on discute le sens de propagation de rainure
					// et en crée les 4 point composante de rectangle en ajoutant l'epaisseure
					if (Util.epsilonEquals(line.Satrtpoint.x, line.EndPoint.x, 0.1f)) {
						PointDXF X1 = new PointDXF();
						PointDXF X2 = new PointDXF();
						PointDXF X3 = new PointDXF();
						PointDXF X4 = new PointDXF();

						float ys = line.Satrtpoint.y;
						float x = line.Satrtpoint.x;
						float ye = line.EndPoint.y;

						X1.x = x - epaisseur / 2;
						X1.y = ys;

						X2.x = x - epaisseur / 2;
						X2.y = ye;

						X3.x = x + epaisseur / 2;
						X3.y = ye;

						X4.x = x + epaisseur / 2;
						X4.y = ys;

						poly.addVertices(X1);
						poly.addVertices(X2);
						poly.addVertices(X3);
						poly.addVertices(X4);
						poly.addVertices(X1);

						s += poly.getDXFEntity(anglerotation);

					}
					if (Util.epsilonEquals(line.Satrtpoint.y, line.EndPoint.y, 0.1f)) {
						PointDXF X1 = new PointDXF();
						PointDXF X2 = new PointDXF();
						PointDXF X3 = new PointDXF();
						PointDXF X4 = new PointDXF();
						float xs = line.Satrtpoint.x;
						float y = line.Satrtpoint.y;
						float xe = line.EndPoint.x;

						X1.x = xs;
						X1.y = y - epaisseur / 2;

						X2.x = xe;
						X2.y = y - epaisseur / 2;

						X3.x = xe;
						X3.y = y + epaisseur / 2;

						X4.x = xs;
						X4.y = y + epaisseur / 2;

						poly.addVertices(X1);
						poly.addVertices(X2);
						poly.addVertices(X3);
						poly.addVertices(X4);
						poly.addVertices(X1);

						s += poly.getDXFEntity(anglerotation);

					}

				}

			}

		}

		return s;
	}

	private static ArrayList<PLineDXFEntity> testingAdjacentRainurefixed(ArrayList<PLineDXFEntity> listRainure2,
			ArrayList<PLineDXFEntity> listdxfsameaxeX, ArrayList<PLineDXFEntity> listdxfsameaxeY) {
		ArrayList<PLineDXFEntity> listdxflineaGenerer = new ArrayList<PLineDXFEntity>();
		int j = listRainure2.size();
		if (j > 0) {
			for (PLineDXFEntity axerainuredxf : listRainure2) {
				if (Util.epsilonEquals(axerainuredxf.Satrtpoint.x, axerainuredxf.EndPoint.x, 0.1f)) {

					listdxfsameaxeX.add(axerainuredxf);

				}
				if (Util.epsilonEquals(axerainuredxf.Satrtpoint.y, axerainuredxf.EndPoint.y, 0.1f)) {

					listdxfsameaxeY.add(axerainuredxf);

				} else
					continue;

			}

		}

		if (listdxfsameaxeY != null && listdxfsameaxeY.size() > 0) {
			ArrayList<PLineDXFEntity> nonAssembledY = new ArrayList<PLineDXFEntity>();
			assembleRainureY(listdxfsameaxeY, nonAssembledY);
			listdxflineaGenerer.addAll(nonAssembledY);
			listdxflineaGenerer.addAll(listdxfsameaxeY);
		}
		if (listdxfsameaxeX != null && listdxfsameaxeX.size() > 0) {
			ArrayList<PLineDXFEntity> nonAssembledX = new ArrayList<PLineDXFEntity>();
			assembleRainureX(listdxfsameaxeX, nonAssembledX);
			listdxflineaGenerer.addAll(nonAssembledX);
			listdxflineaGenerer.addAll(listdxfsameaxeX);
		}

		return listdxflineaGenerer;

	}

	private static void assembleRainureY(ArrayList<PLineDXFEntity> listdxfsameaxeY,
			ArrayList<PLineDXFEntity> nonAssembledY) {
		PLineDXFEntity matchedrainure = null;
		if (listdxfsameaxeY.size() > 1) {
			int i = 0;
			float x1 = listdxfsameaxeY.get(0).Satrtpoint.x;
			float x = listdxfsameaxeY.get(0).EndPoint.x;
			float y = listdxfsameaxeY.get(0).EndPoint.y;
			PLineDXFEntity lineatester = listdxfsameaxeY.get(0);
			listdxfsameaxeY.remove(0);

			for (PLineDXFEntity axerainuredxfy : listdxfsameaxeY) {

				if ((Util.epsilonEquals(axerainuredxfy.Satrtpoint.y, y, 0.1f))
						&& ((Math.abs(axerainuredxfy.Satrtpoint.x - x) < 20)
								&& (Math.abs(axerainuredxfy.Satrtpoint.x - x) > 0))
						|| ((Math.abs(axerainuredxfy.EndPoint.x - x1) < 20)
								&& (Math.abs(axerainuredxfy.EndPoint.x - x1) > 0))) {
					matchedrainure = axerainuredxfy;
					break;

				}
				i++;
			}
			if (matchedrainure != null) {
				PointDXF p1 = new PointDXF();
				PointDXF p2 = new PointDXF();
				p1.x = x1;
				p1.y = y;
				p2.y = y;
				p2.x = matchedrainure.EndPoint.x;
				PLineDXFEntity axerainureassemble = new PLineDXFEntity(p1, p2);
				listdxfsameaxeY.remove(matchedrainure);
				listdxfsameaxeY.add(0, axerainureassemble);
				assembleRainureY(listdxfsameaxeY, nonAssembledY);
			} else {
				nonAssembledY.add(lineatester);
			}
		}

	}

	private static void assembleRainureX(ArrayList<PLineDXFEntity> listdxfsameaxeX,
			ArrayList<PLineDXFEntity> nonAssembledX) {
		PLineDXFEntity matchedrainure = null;
		if (listdxfsameaxeX.size() > 1) {
			float y1 = listdxfsameaxeX.get(0).Satrtpoint.y;
			float x = listdxfsameaxeX.get(0).EndPoint.x;
			float y = listdxfsameaxeX.get(0).EndPoint.y;
			PLineDXFEntity lineatester = listdxfsameaxeX.get(0);
			listdxfsameaxeX.remove(0);
			for (PLineDXFEntity axerainuredxfx : listdxfsameaxeX) {
				if ((Util.epsilonEquals(axerainuredxfx.Satrtpoint.x, x, 0.1f))
						&& ((Math.abs(axerainuredxfx.Satrtpoint.y - y) < 20)
								&& (Math.abs(axerainuredxfx.Satrtpoint.y - y) > 0))
						|| ((Math.abs(axerainuredxfx.EndPoint.y - y1) < 20)
								&& (Math.abs(axerainuredxfx.EndPoint.y - y1) > 0))) {
					matchedrainure = axerainuredxfx;
					break;
				}
			}
			if (matchedrainure != null) {
				PointDXF p1 = new PointDXF();
				PointDXF p2 = new PointDXF();
				p1.x = x;
				p1.y = y1;
				p2.y = matchedrainure.EndPoint.y;
				p2.x = x;
				PLineDXFEntity axerainureassemble = new PLineDXFEntity(p1, p2);
				listdxfsameaxeX.remove(matchedrainure);
				listdxfsameaxeX.add(0, axerainureassemble);

				assembleRainureX(listdxfsameaxeX, nonAssembledX);

			} else {
				nonAssembledX.add(lineatester);
			}

		}

	}

	public static String getDXFLineEntetity(PlanUsinage persp, Piece2D piece2d, Rotationangle anglerotation, Trou tr) {
		// TODO Auto-generated method stub
		String s = "";
		PointDXF centre = DXFUtils.getcenter(persp, piece2d, tr);

		PCircleDXFEntity2 circle = new PCircleDXFEntity2(centre, tr.getDiameter() / 2);

		s += circle.getDXFLineEntetityCircle(anglerotation);

		return s;
	}

	public static String getDXFLineEntetityLateral(PlanUsinage persp, Piece2D piece2d, Rotationangle anglederotaion,
			Trou tr) {
		String s = "";
		if (ReportingPreferences.getInstance().getProperty("DXF.TrouLateraleRectangle", false)) {

			PointDXF centre = DXFUtils.getcenter(persp, piece2d, tr);
			PointDXF end = DXFUtils.getcenterEnd(persp, piece2d, tr);
			float width = 0;
			float height = 0;

			float x0 = 0;
			float y0 = 0;
			if (centre.x == end.x) {
				width = (float) tr.getDiameter();
				height = (float) tr.getDepth();
				x0 = centre.x - width / 2;
				y0 = Math.min(centre.y, end.y);
			} else {
				width = (float) tr.getDepth();
				height = (float) tr.getDiameter();

				x0 = Math.min(centre.x, end.x);
				y0 = centre.y - height / 2;
			}
			PointDXF p1 = new PointDXF(x0, y0);
			PointDXF p2 = new PointDXF(x0 + width, y0);
			PointDXF p3 = new PointDXF(x0 + width, y0 + height);
			PointDXF p4 = new PointDXF(x0, y0 + height);
			PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
			poly.addVertices(p1);
			poly.addVertices(p2);
			poly.addVertices(p3);
			poly.addVertices(p4);
			poly.addVertices(p1);

			s += poly.getDXFEntity(anglederotaion);

		} else {
			PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
			PointDXF centre = DXFUtils.getcenter(persp, piece2d, tr);
			PointDXF end = DXFUtils.getcenterEnd(persp, piece2d, tr);
			float width = 0;
			float height = 0;

			float x0 = 0;
			float y0 = 0;
			if (centre.x == end.x) {
				width = (float) tr.getDiameter();
				height = (float) tr.getDepth();
				x0 = centre.x;
				y0 = Math.min(centre.y, end.y);
				PointDXF p1 = new PointDXF(x0, y0);
				PointDXF p2 = new PointDXF(x0, y0 + height);

				poly.addVertices(p1);
				poly.addVertices(p2);
				poly.addVertices(p1);
			} else {
				width = (float) tr.getDepth();
				height = (float) tr.getDiameter();

				x0 = Math.min(centre.x, end.x);
				y0 = centre.y;
				PointDXF p1 = new PointDXF(x0, y0);
				PointDXF p2 = new PointDXF(x0 + width, y0);

				poly.addVertices(p1);
				poly.addVertices(p2);
				poly.addVertices(p1);
			}

			s += poly.getDXFEntity(anglederotaion);

		}
		return s;
	}

	public static PointDXF getcenter(PlanUsinage persp, Piece2D piece2d, Trou tr) {
		PointDXF centre = new PointDXF(0, 0);

		centre.x = (float) Util.getXcenter(tr, persp);
		centre.y = (float) Util.getYcenter(tr, persp);

		return centre;
	}

	public static PointDXF getcenterEnd(PlanUsinage persp, Piece2D piece2d, Trou tr) {
		Vector3 endpoint = tr.getEnd();
		PointDXF centre = new PointDXF(0, 0);
		float width = (float) Util.getDesignWidth(piece2d, persp);
		float height = (float) Util.getDesignHeight(piece2d, persp);

		switch (persp) {
		case FRONT:
			centre.x = endpoint.x;
			centre.y = endpoint.y;
			break;
		case BACK:
			centre.x = width - endpoint.x;
			centre.y = endpoint.y;
			break;

		case RIGHT:
			centre.x = width - endpoint.z;
			centre.y = endpoint.y;
			break;
		case LEFT:
			centre.x = (endpoint.z);
			centre.y = endpoint.y;
			break;
		case DOWN:
			centre.x = endpoint.x;
			centre.y = height - endpoint.z;
			break;
		case TOP:
			centre.x = endpoint.x;
			centre.y = height - endpoint.z;
			break;
		default:
			break;
		}

		return centre;
	}
}
