package com.frs.supercad.dressing.internal;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Vector3;

public class GdxApp extends ApplicationAdapter{

	ModelBatch batch;
	PerspectiveCamera camera;
	ModelInstance sphere;
	
	
	
	@Override
	public void create() {
		Model model = new ModelBuilder().createSphere(1, 1, 1, 24, 24,
				new Material(ColorAttribute.createDiffuse(Color.BLUE)), VertexAttributes.Usage.Position);
		sphere = new ModelInstance(model);
		camera = new PerspectiveCamera(45, 10, 7.5f);
		camera.near = 0.1f;
		camera.far = 20;
		camera.position.set(0,0,5);
		camera.lookAt(new Vector3());
		camera.update();
		batch = new ModelBatch();
	}

	@Override
	public void dispose() {		
	}

	@Override
	public void pause() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void render() {
		Gdx.gl20.glClearColor(1.0f, 0,0, 1.0f);
        Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT | (Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
        batch.begin(camera);
        batch.render(sphere);
        batch.end();
	}

	@Override
	public void resize(int arg0, int arg1) {
		
	}

	@Override
	public void resume() {
		// TODO Auto-generated method stub
		
	}

}
