#version 400 core

uniform mat4 model;
uniform mat4 vp;
uniform mat3 normal;

layout(location = 0) in vec3 a_position;
layout(location = 1) in vec3 a_normal;
layout(location = 2) in vec2 a_texcoord;

out VertexData
{
    vec3 v_position;
    vec3 v_normal;
    vec2 v_texcoord;
} outData;

void main(void)
{
    outData.v_position = (model * vec4(a_position, 1.0)).xyz;
    outData.v_normal = normalize(normal * a_normal);
    outData.v_texcoord = a_texcoord;

    gl_Position = vp * model * vec4(a_position, 1.0);
}