/*
 * Decompiled with CFR 0.152.
 */
package internal;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

public class Torus {
    static void drawTorus(float r, float R, int nsides, int rings) {
        float ringDelta = (float)Math.PI * 2 / (float)rings;
        float sideDelta = (float)Math.PI * 2 / (float)nsides;
        float theta = 0.0f;
        float cosTheta = 1.0f;
        float sinTheta = 0.0f;
        int i = rings - 1;
        while (i >= 0) {
            float theta1 = theta + ringDelta;
            float cosTheta1 = (float)Math.cos(theta1);
            float sinTheta1 = (float)Math.sin(theta1);
            GL11.glBegin((int)8);
            float phi = 0.0f;
            int j = nsides;
            while (j >= 0) {
                float cosPhi = (float)Math.cos(phi += sideDelta);
                float sinPhi = (float)Math.sin(phi);
                float dist = R + r * cosPhi;
                GL11.glNormal3f((float)(cosTheta1 * cosPhi), (float)(-sinTheta1 * cosPhi), (float)sinPhi);
                GL11.glVertex3f((float)(cosTheta1 * dist), (float)(-sinTheta1 * dist), (float)(r * sinPhi));
                GL11.glNormal3f((float)(cosTheta * cosPhi), (float)(-sinTheta * cosPhi), (float)sinPhi);
                GL11.glVertex3f((float)(cosTheta * dist), (float)(-sinTheta * dist), (float)(r * sinPhi));
                --j;
            }
            GL11.glEnd();
            theta = theta1;
            cosTheta = cosTheta1;
            sinTheta = sinTheta1;
            --i;
        }
    }

    public static void main(String[] args) {
        final Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Composite comp = new Composite((Composite)shell, 0);
        comp.setLayout((Layout)new FillLayout());
        GLData data = new GLData();
        data.doubleBuffer = true;
        final GLCanvas canvas = new GLCanvas(comp, 0, data);
        canvas.setCurrent();
        GL.createCapabilities();
        canvas.addListener(11, event -> {
            Rectangle bounds = canvas.getBounds();
            float fAspect = (float)bounds.width / (float)bounds.height;
            canvas.setCurrent();
            GL.createCapabilities();
            GL11.glViewport((int)0, (int)0, (int)bounds.width, (int)bounds.height);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            float near = 0.5f;
            float bottom = -near * (float)Math.tan(22.5);
            float left = fAspect * bottom;
            GL11.glFrustum((double)left, (double)(-left), (double)bottom, (double)(-bottom), (double)near, (double)400.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
        });
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glHint((int)3152, (int)4354);
        GL11.glClearDepth((double)1.0);
        GL11.glLineWidth((float)2.0f);
        GL11.glEnable((int)2929);
        shell.setText("SWT/LWJGL Example");
        shell.setSize(640, 480);
        shell.open();
        Runnable run = new Runnable(){
            int rot = 0;

            @Override
            public void run() {
                if (!canvas.isDisposed()) {
                    canvas.setCurrent();
                    GL.createCapabilities();
                    GL11.glClear((int)16640);
                    GL11.glClearColor((float)0.3f, (float)0.5f, (float)0.8f, (float)1.0f);
                    GL11.glLoadIdentity();
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-10.0f);
                    float frot = this.rot;
                    GL11.glRotatef((float)(0.15f * (float)this.rot), (float)(2.0f * frot), (float)(10.0f * frot), (float)1.0f);
                    GL11.glRotatef((float)(0.3f * (float)this.rot), (float)(3.0f * frot), (float)(1.0f * frot), (float)1.0f);
                    ++this.rot;
                    GL11.glPolygonMode((int)1032, (int)6913);
                    GL11.glColor3f((float)0.9f, (float)0.9f, (float)0.9f);
                    Torus.drawTorus(1.0f, 1.9f + (float)Math.sin(0.004f * frot), 15, 15);
                    canvas.swapBuffers();
                    display.asyncExec((Runnable)this);
                }
            }
        };
        canvas.addListener(9, event -> run.run());
        display.asyncExec(run);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

