/*
 * Decompiled with CFR 0.152.
 */
package api.ui;

import api.graphics.Camera;
import api.graphics.ModelInstance;
import api.ui.CameraController;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class OrbitCameraController
implements CameraController {
    private Camera camera;
    private ModelInstance target;
    private boolean mouseIsDown;
    private Vector2i lastMousePosition = new Vector2i();
    private Vector2i lastClickPosition = new Vector2i();
    private boolean cameraFrozen;

    public OrbitCameraController(Camera camera) {
        this.camera = camera;
    }

    public void lookAtSide(Vector3f side) {
        Vector4f worldDir = new Vector4f((Vector3fc)side, 0.0f).mul((Matrix4fc)this.target.getTransform());
        float length = this.camera.getPosition().distance((Vector3fc)this.target.getCenter());
        this.camera.setPosition(this.target.getCenter().add((Vector3fc)new Vector3f(worldDir.x, worldDir.y, worldDir.z).normalize(length)));
        this.camera.lookAt(this.target.getCenter());
    }

    @Override
    public boolean mouseDoubleClick(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseDown(MouseEvent e) {
        this.mouseIsDown = true;
        this.lastClickPosition = new Vector2i(e.x, e.y);
        return false;
    }

    @Override
    public boolean mouseUp(MouseEvent e) {
        this.mouseIsDown = false;
        return false;
    }

    @Override
    public boolean mouseMove(MouseEvent e) {
        if (this.mouseIsDown) {
            this.mouseDragged(e);
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(MouseEvent e) {
        int amount = -e.count;
        float fov = this.camera.getZoom() + (float)amount * 0.5f;
        this.camera.setZoom(fov);
        return true;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        Vector2i currentMouseLocation = new Vector2i(e.x, e.y);
        Vector2f delta = new Vector2f((Vector2ic)currentMouseLocation).sub((float)this.lastClickPosition.x, (float)this.lastClickPosition.y);
        delta.mul(this.camera.getMouseSensitivity(), -this.camera.getMouseSensitivity());
        float azimuth = 2.0f * delta.x;
        float polar = 4.0f * delta.y;
        Vector3f targetToCamera = new Vector3f((Vector3fc)this.camera.getPosition()).sub((Vector3fc)this.target.getCenter());
        if (Math.abs(polar) > Math.abs(azimuth)) {
            targetToCamera.rotateX((float)Math.toRadians(polar));
        } else {
            targetToCamera.rotateY((float)Math.toRadians(azimuth));
        }
        this.camera.setPosition(this.target.getCenter().add((Vector3fc)targetToCamera));
        this.camera.lookAt(this.target.getCenter());
        this.lastClickPosition.set((Vector2ic)currentMouseLocation);
        return false;
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (e.keyCode == 16777269) {
            this.lookAtSide(new Vector3f(0.0f, 0.0f, 1.0f));
        } else if (e.keyCode == 16777272) {
            this.lookAtSide(new Vector3f(0.0f, 1.0f, 0.0f));
        } else if (e.keyCode == 16777266) {
            this.lookAtSide(new Vector3f(0.0f, -1.0f, 0.0f));
        } else if (e.keyCode == 16777268) {
            this.lookAtSide(new Vector3f(-1.0f, 0.0f, 0.0f));
        } else if (e.keyCode == 16777270) {
            this.lookAtSide(new Vector3f(1.0f, 0.0f, 0.0f));
        } else if (e.character == 'z') {
            this.camera.move(Camera.Camera_Movement.FORWARD, 0.1f);
        } else if (e.character == 's') {
            this.camera.move(Camera.Camera_Movement.BACKWARD, 0.1f);
        }
        return false;
    }

    @Override
    public boolean keyReleased(KeyEvent e) {
        return false;
    }

    public ModelInstance getTarget() {
        return this.target;
    }

    public void setTarget(ModelInstance target) {
        this.target = target;
    }

    @Override
    public void freezeCamera(boolean freeze) {
        this.cameraFrozen = freeze;
    }
}

