/*
 * Decompiled with CFR 0.152.
 */
package api.ui;

import api.graphics.Camera;
import api.graphics.IDrawable;
import api.graphics.Mesh;
import api.graphics.Model;
import api.graphics.ModelInstance;
import api.graphics.Shader;
import api.graphics.geometry.MeshBuilder;
import api.ui.CameraController;
import api.ui.FlyCameraController;
import api.ui.OrbitCameraController;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DualModeCameraController
implements CameraController,
IDrawable {
    private Camera camera;
    private CameraController currentController;
    private FlyCameraController flyCameraController;
    private OrbitCameraController orbitCamera;
    private boolean freeze;
    private ModelInstance cube;

    public DualModeCameraController(Camera camera) {
        this.camera = camera;
        this.createControllers();
        this.createDrawable();
    }

    private void createDrawable() {
        Mesh mesh = MeshBuilder.createCameraBox();
        Model model = new Model(mesh);
        this.cube = new ModelInstance(model);
    }

    private void createControllers() {
        this.flyCameraController = new FlyCameraController(this.camera);
        this.orbitCamera = new OrbitCameraController(this.camera);
        this.setMode(Camera.CAMERA_MODE.FLY);
        this.setToPerspective();
    }

    @Override
    public boolean mouseDoubleClick(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseDown(MouseEvent e) {
        return this.currentController.mouseDown(e);
    }

    @Override
    public boolean mouseUp(MouseEvent e) {
        return this.currentController.mouseUp(e);
    }

    @Override
    public boolean mouseMove(MouseEvent e) {
        if (this.freeze) {
            return false;
        }
        return this.currentController.mouseMove(e);
    }

    @Override
    public boolean mouseScrolled(MouseEvent e) {
        return this.currentController.mouseScrolled(e);
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        return this.currentController.mouseDragged(e);
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        return this.currentController.keyPressed(e);
    }

    @Override
    public boolean keyReleased(KeyEvent e) {
        return this.currentController.keyReleased(e);
    }

    public void setToOrtho() {
        this.camera.setOrthographic(true);
    }

    public void setToPerspective() {
        this.camera.setOrthographic(false);
    }

    public void setMode(Camera.CAMERA_MODE mode) {
        if (mode == Camera.CAMERA_MODE.FLY) {
            this.currentController = this.flyCameraController;
        } else if (mode == Camera.CAMERA_MODE.ORBIT) {
            this.currentController = this.orbitCamera;
        }
    }

    @Override
    public void draw(Shader shader, Camera cam) {
        Matrix3f rot = new Matrix3f();
        this.camera.GetViewMatrix().get3x3(rot);
        rot.scale(5.0E-4f);
        this.cube.getTransform().set((Matrix3fc)rot);
        float v = this.camera.getNearQuadHeight();
        float h = this.camera.getNearQuadWidth();
        Vector3f pos = new Vector3f((Vector3fc)this.camera.getPosition()).add((Vector3fc)this.camera.getFront().normalize(0.011f)).add((Vector3fc)this.camera.getUp().normalize(v - 5.0E-5f)).add((Vector3fc)this.camera.getRight().normalize(h));
        this.cube.getTransform().setTranslation((Vector3fc)pos);
        this.cube.draw(shader, this.camera);
    }

    @Override
    public void drawVertices(Camera camera) {
    }

    @Override
    public void drawSilhouette(Camera camera) {
    }

    public OrbitCameraController getOrbitCamera() {
        return this.orbitCamera;
    }

    @Override
    public void freezeCamera(boolean freeze) {
        this.freeze = freeze;
    }
}

