/*
 * Decompiled with CFR 0.152.
 */
package api.graphics.geometry;

import api.graphics.Camera;
import api.graphics.Mesh;
import api.graphics.PbrMaterial;
import api.graphics.Shader;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL45;

public class Line
extends Mesh {
    private Vector3f v0;
    private Vector3f v1;

    public Line(Vector3f v0, Vector3f v1) {
        super(new Mesh[0]);
        this.v0 = v0;
        this.v1 = v1;
        this.setupMesh();
    }

    @Override
    public void setupMesh() {
        float[] bufferData = new float[]{this.v0.x, this.v0.y, this.v0.z, this.v1.x, this.v1.y, this.v1.z};
        this.VAO = GL45.glGenVertexArrays();
        this.VBO = GL45.glGenBuffers();
        GL30.glBindVertexArray((int)this.VAO);
        GL45.glBindBuffer((int)34962, (int)this.VBO);
        GL45.glBufferData((int)34962, (float[])bufferData, (int)35044);
        GL45.glEnableVertexAttribArray((int)0);
        GL45.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)12, (long)0L);
        GL30.glBindVertexArray((int)0);
        GL45.glBindBuffer((int)34962, (int)0);
    }

    @Override
    public void draw(Shader shader, Camera camera) {
        shader.setMat4("model", this.transform);
        shader.setMat3("normal", new Matrix4f((Matrix4fc)this.transform).normal().get3x3(new Matrix3f()));
        shader.bindMaterial((PbrMaterial)this.mtl);
        GL30.glBindVertexArray((int)this.VAO);
        GL11.glDrawArrays((int)1, (int)0, (int)2);
        GL30.glBindVertexArray((int)0);
        if (this.parts != null) {
            for (Mesh part : this.parts) {
                part.draw(shader, camera);
            }
        }
    }
}

