/*
 * Decompiled with CFR 0.152.
 */
package api.graphics.geometry;

import api.graphics.Camera;
import api.graphics.Mesh;
import api.graphics.PbrMaterial;
import api.graphics.Shader;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL45;

public class Circle
extends Mesh {
    private int segments = 24;
    private Vector3f[] vertices;

    public Circle(int segs, PbrMaterial material) {
        super(new Mesh[0]);
        this.segments = segs;
        this.mtl = material;
        this.create();
    }

    public void create() {
        Vector3f pointer = new Vector3f(1.0f, 0.0f, 0.0f);
        float angularStep = (float)(Math.PI * 2 / (double)this.segments);
        this.vertices = new Vector3f[this.segments];
        int i = 0;
        while (i < this.segments) {
            this.vertices[i] = new Vector3f((Vector3fc)pointer).rotateAxis((float)i * angularStep, 0.0f, 1.0f, 0.0f);
            ++i;
        }
        this.setupMesh();
    }

    @Override
    protected float[] prepareVerticesData() {
        float[] vertexData = new float[this.vertices.length * 3];
        int c = 0;
        int i = 0;
        while (i < this.vertices.length) {
            vertexData[c++] = this.vertices[i].x;
            vertexData[c++] = this.vertices[i].y;
            vertexData[c++] = this.vertices[i].z;
            ++i;
        }
        return vertexData;
    }

    @Override
    public void setupMesh() {
        float[] bufferData = this.prepareVerticesData();
        this.VAO = GL45.glGenVertexArrays();
        this.VBO = GL45.glGenBuffers();
        GL30.glBindVertexArray((int)this.VAO);
        GL45.glBindBuffer((int)34962, (int)this.VBO);
        GL45.glBufferData((int)34962, (float[])bufferData, (int)35044);
        GL45.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)12, (long)0L);
        GL30.glBindVertexArray((int)0);
    }

    @Override
    public void draw(Shader shader, Camera camera) {
        shader.setMat4("model", this.transform);
        shader.bindMaterial((PbrMaterial)this.mtl);
        GL30.glBindVertexArray((int)this.VAO);
        GL45.glDrawArrays((int)2, (int)0, (int)this.segments);
        GL30.glBindVertexArray((int)0);
    }
}

