/*
 * Decompiled with CFR 0.152.
 */
package api.graphics.geometry;

import api.graphics.Mesh;
import api.graphics.PbrMaterial;
import api.graphics.Vertex;
import api.graphics.geometry.Quad;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Box
extends Mesh {
    public Box(PbrMaterial mtl) {
        super(new Mesh[0]);
        this.mtl = mtl;
        this.indices = new int[36];
        int i = 0;
        while (i < 36) {
            this.indices[i] = i;
            ++i;
        }
        this.setupMesh();
    }

    @Override
    protected float[] prepareVerticesData() {
        float[] verticesData = new float[]{-0.5f, -0.5f, -0.5f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.5f, -0.5f, -0.5f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.5f, 0.5f, -0.5f, 0.0f, 0.0f, -1.0f, 1.0f, 1.0f, 0.5f, 0.5f, -0.5f, 0.0f, 0.0f, -1.0f, 1.0f, 1.0f, -0.5f, 0.5f, -0.5f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, -0.5f, -0.5f, -0.5f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -0.5f, -0.5f, 0.5f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f, -0.5f, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, -0.5f, 0.5f, 0.5f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, -0.5f, -0.5f, 0.5f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -0.5f, 0.5f, 0.5f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, -0.5f, 0.5f, -0.5f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f, -0.5f, -0.5f, -0.5f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -0.5f, -0.5f, -0.5f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -0.5f, -0.5f, 0.5f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.5f, 0.5f, 0.5f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.5f, 0.5f, -0.5f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f, -0.5f, -0.5f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.5f, -0.5f, -0.5f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.5f, -0.5f, 0.5f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, -0.5f, -0.5f, -0.5f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.5f, -0.5f, -0.5f, 0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.5f, -0.5f, 0.5f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.5f, -0.5f, 0.5f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, -0.5f, -0.5f, 0.5f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -0.5f, -0.5f, -0.5f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, -0.5f, 0.5f, -0.5f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f, -0.5f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, -0.5f, 0.5f, 0.5f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, -0.5f, 0.5f, -0.5f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        this.vertices = new Vertex[36];
        int i = 0;
        while (i < 36) {
            Vector3f position = new Vector3f(verticesData[8 * i], verticesData[8 * i + 1], verticesData[8 * i + 2]);
            Vector3f normal = new Vector3f(verticesData[8 * i + 3], verticesData[8 * i + 4], verticesData[8 * i + 5]);
            Vector2f textcoords = new Vector2f(verticesData[8 * i + 6], verticesData[8 * i + 7]);
            Vertex vertex = new Vertex();
            vertex.setPosition(position);
            vertex.setNormal(normal);
            vertex.setTextCoords(textcoords);
            this.vertices[i] = vertex;
            ++i;
        }
        return verticesData;
    }

    @Override
    public void setupMesh() {
        Vector3f halfDim = new Vector3f(0.5f, 0.5f, 0.5f);
        Vector3f c000 = new Vector3f((Vector3fc)halfDim).mul(-1.0f, -1.0f, -1.0f);
        Vector3f c001 = new Vector3f((Vector3fc)halfDim).mul(-1.0f, -1.0f, 1.0f);
        Vector3f c010 = new Vector3f((Vector3fc)halfDim).mul(-1.0f, 1.0f, -1.0f);
        Vector3f c011 = new Vector3f((Vector3fc)halfDim).mul(-1.0f, 1.0f, 1.0f);
        Vector3f c100 = new Vector3f((Vector3fc)halfDim).mul(1.0f, -1.0f, -1.0f);
        Vector3f c101 = new Vector3f((Vector3fc)halfDim).mul(1.0f, -1.0f, 1.0f);
        Vector3f c110 = new Vector3f((Vector3fc)halfDim).mul(1.0f, 1.0f, -1.0f);
        Vector3f c111 = new Vector3f((Vector3fc)halfDim).mul(1.0f, 1.0f, 1.0f);
        Quad xPlus = new Quad(c110, c111, c101, c100);
        Quad xNeg = new Quad(c000, c001, c011, c010);
        Quad yPlus = new Quad(c010, c011, c111, c110);
        Quad yNeg = new Quad(c001, c000, c100, c011);
        Quad zPlus = new Quad(c011, c001, c101, c111);
        Quad zNeg = new Quad(c110, c100, c000, c010);
        xPlus.setMtl(this.mtl);
        xNeg.setMtl(this.mtl);
        yPlus.setMtl(this.mtl);
        yNeg.setMtl(this.mtl);
        zPlus.setMtl(this.mtl);
        zNeg.setMtl(this.mtl);
        this.addParts(xPlus, xNeg, yPlus, yNeg, zPlus, zNeg);
    }
}

