/*
 * Decompiled with CFR 0.152.
 */
package api.graphics.geometry;

import java.util.ArrayList;
import java.util.List;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BezierCurve {
    private List<Vector3f> controlPoints = new ArrayList<Vector3f>();
    private List<Vector3f> curvePoints = new ArrayList<Vector3f>();
    private int steps = 100;

    public BezierCurve(List<Vector3f> controlPoints) {
        this.controlPoints.addAll(controlPoints);
    }

    private Vector3f at(float t) {
        ArrayList<Vector3f> midPoints = new ArrayList<Vector3f>(this.controlPoints);
        while (midPoints.size() > 2) {
            ArrayList<Vector3f> tmpList = new ArrayList<Vector3f>();
            int i = 0;
            while (i < midPoints.size() - 1) {
                Vector3f v = new Vector3f((Vector3fc)midPoints.get(i + 1)).sub((Vector3fc)midPoints.get(i));
                tmpList.add(v.mul(t).add((Vector3fc)midPoints.get(i)));
                ++i;
            }
            midPoints.clear();
            midPoints.addAll(tmpList);
        }
        Vector3f point = midPoints.get(1).mul(t).add((Vector3fc)midPoints.get(0).mul(1.0f - t));
        return point;
    }

    public List<Vector3f> calculatePoint(int steps) {
        this.steps = steps;
        this.curvePoints.clear();
        float step = 1.0f / (float)steps;
        int i = 0;
        while (i < steps) {
            this.curvePoints.add(this.at(step * (float)i));
            ++i;
        }
        return this.curvePoints;
    }
}

