/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.graphics.IDisposable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL45;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageWrite;

public class Texture
implements IDisposable {
    private int handle;
    private int width = -1;
    private int height = -1;
    private int channels;
    private String path;
    private int internalFormat;

    public Texture(String path) {
        this.path = path;
    }

    public Texture() {
    }

    public void load() throws IOException {
        this.generate();
    }

    public void checkInfo() {
        int[] width = new int[1];
        int[] height = new int[1];
        int[] channels = new int[1];
        try {
            STBImage.stbi_set_flip_vertically_on_load((boolean)true);
            ByteBuffer buffer = STBImage.stbi_load((CharSequence)this.path, (int[])width, (int[])height, (int[])channels, (int)0);
            this.width = width[0];
            this.height = height[0];
            this.channels = channels[0];
            STBImage.stbi_image_free((ByteBuffer)buffer);
        }
        catch (Exception exception) {
            System.err.println("failed to retrieve texture info " + this.path);
        }
    }

    public void generate() {
        this.checkInfo();
        ByteBuffer buffer = STBImage.stbi_load((CharSequence)this.path, (int[])new int[1], (int[])new int[1], (int[])new int[1], (int)this.channels);
        int format = 6407;
        if (this.channels == 1) {
            format = 6403;
        } else if (this.channels > 3) {
            format = 6408;
        }
        this.internalFormat = format;
        this.handle = GL20.glGenTextures();
        GL20.glBindTexture((int)3553, (int)this.handle);
        GL20.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL20.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL20.glTexParameteri((int)3553, (int)10240, (int)9729);
        try {
            GL20.glTexImage2D((int)3553, (int)0, (int)this.internalFormat, (int)this.width, (int)this.height, (int)0, (int)format, (int)5121, (ByteBuffer)buffer);
        }
        catch (Exception exception) {
            System.err.println("error loading texture " + this.path);
        }
        if (buffer != null) {
            STBImage.stbi_image_free((ByteBuffer)buffer);
        }
    }

    public float readPixel(int screenX, int screenY) {
        if (this.width < 0) {
            this.queryProperties();
        }
        int y = this.getHeight() - screenY;
        float[] buffer = new float[4];
        GL45.glGetTextureSubImage((int)this.handle, (int)0, (int)screenX, (int)y, (int)0, (int)1, (int)1, (int)1, (int)6408, (int)5126, (float[])buffer);
        return buffer[0];
    }

    public void queryProperties() {
        this.width = GL45.glGetTextureLevelParameteri((int)this.handle, (int)0, (int)4096);
        this.height = GL45.glGetTextureLevelParameteri((int)this.handle, (int)0, (int)4097);
        this.internalFormat = GL45.glGetTextureLevelParameteri((int)this.handle, (int)0, (int)4099);
        int[] format = new int[1];
        GL45.glGetTextureLevelParameteriv((int)this.handle, (int)0, (int)4099, (int[])format);
        switch (format[0]) {
            case 6402: 
            case 6403: {
                this.channels = 1;
                break;
            }
            case 6407: {
                this.channels = 3;
                break;
            }
            case 6408: {
                this.channels = 4;
            }
            default: {
                this.channels = 4;
            }
        }
    }

    public void exportTextureToFile(String filePath) {
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(this.width * this.height));
        GL45.glGetTextureImage((int)this.handle, (int)0, (int)6403, (int)5121, (ByteBuffer)buffer);
        boolean success = STBImageWrite.stbi_write_png((CharSequence)filePath, (int)this.width, (int)this.height, (int)this.channels, (ByteBuffer)buffer, (int)this.width);
        if (!success) {
            throw new RuntimeException("Failed to write PNG to " + filePath);
        }
        System.out.println("Texture exported successfully to " + filePath);
    }

    public int getHandle() {
        return this.handle;
    }

    public void setHandle(int handle) {
        this.handle = handle;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getChannels() {
        return this.channels;
    }

    public void setChannels(int channels) {
        this.channels = channels;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void dispose() {
        GL30.glDeleteTextures((int)this.handle);
    }
}

