/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.graphics.Camera;
import api.graphics.PbrMaterial;
import api.graphics.Texture;
import api.utils.RessourceLoader;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL20;

public class Shader {
    private int id;
    private RessourceLoader ressourceLoader = new RessourceLoader();

    public Shader(String pathToVertexShader, String pathToFragmentShader) {
        this.loadAndCompile(pathToVertexShader, pathToFragmentShader);
    }

    private void loadAndCompile(String pathToVertexShader, String pathToFragmentShader) {
        String vertexSource = null;
        String fragSource = null;
        try {
            vertexSource = this.ressourceLoader.loadResource(pathToVertexShader);
            fragSource = this.ressourceLoader.loadResource(pathToFragmentShader);
        }
        catch (Exception exception) {
            throw new RuntimeException("failed to load shader sources");
        }
        this.compile(vertexSource, fragSource);
    }

    public void compile(String vertexShaderSource, String fragmentShaderSource) {
        int vertexShader = GL20.glCreateShader((int)35633);
        GL20.glShaderSource((int)vertexShader, (CharSequence)vertexShaderSource);
        GL20.glCompileShader((int)vertexShader);
        if (GL20.glGetShaderi((int)vertexShader, (int)35713) != 1) {
            throw new IllegalStateException("Vertex shader compilation failed: " + GL20.glGetShaderInfoLog((int)vertexShader));
        }
        int fragmentShader = GL20.glCreateShader((int)35632);
        GL20.glShaderSource((int)fragmentShader, (CharSequence)fragmentShaderSource);
        GL20.glCompileShader((int)fragmentShader);
        if (GL20.glGetShaderi((int)fragmentShader, (int)35713) != 1) {
            throw new IllegalStateException("Fragment shader compilation failed: " + GL20.glGetShaderInfoLog((int)fragmentShader));
        }
        this.id = GL20.glCreateProgram();
        GL20.glAttachShader((int)this.id, (int)vertexShader);
        GL20.glAttachShader((int)this.id, (int)fragmentShader);
        GL20.glLinkProgram((int)this.id);
        if (GL20.glGetProgrami((int)this.id, (int)35714) != 1) {
            throw new IllegalStateException("Shader program linking failed: " + GL20.glGetProgramInfoLog((int)this.id));
        }
        GL20.glDeleteShader((int)vertexShader);
        GL20.glDeleteShader((int)fragmentShader);
    }

    public void use() {
        GL20.glUseProgram((int)this.id);
    }

    public void bindMaterial(PbrMaterial material) {
        this.setFloat("u_roughness", material.getRoughness());
        this.setFloat("u_metalness", material.getMetalness());
        this.setFloat("u_opacity", material.getOpacity());
        if (material.getAlbedo() != null) {
            this.setVec3("u_albedo", material.getAlbedo());
        }
        int textureUnit = 0;
        if (material.getAlbedoMap() != null) {
            this.setSampler2D(3553, "albedoMap", material.getAlbedoMap(), textureUnit++);
            this.setInt("has_albedo_map", 1);
        } else {
            this.setInt("has_albedo_map", 0);
        }
        if (material.getNormalMap() != null) {
            this.setSampler2D(3553, "normalMap", material.getNormalMap(), textureUnit++);
            this.setInt("has_normal_map", 1);
        } else {
            this.setInt("has_normal_map", 0);
        }
        if (material.getMetalnessMap() != null) {
            this.setSampler2D(3553, "metallicMap", material.getMetalnessMap(), textureUnit++);
            this.setInt("has_metallic_map", 1);
        } else {
            this.setInt("has_metallic_map", 0);
        }
        if (material.getRoughnessMap() != null) {
            this.setSampler2D(3553, "roughnessMap", material.getRoughnessMap(), textureUnit++);
            this.setInt("has_roughness_map", 1);
        } else {
            this.setInt("has_roughness_map", 0);
        }
    }

    public void begin(Camera camera) {
        this.use();
        this.setMat4("vp", camera.GetProjectionMatrix().mul((Matrix4fc)camera.GetViewMatrix()));
    }

    public void setSampler2D(int target, String name, Texture texture, int unit) {
        int location = GL20.glGetUniformLocation((int)this.id, (CharSequence)name);
        if (location >= 0) {
            GL20.glUniform1i((int)location, (int)unit);
            GL20.glActiveTexture((int)(33984 + unit));
            GL20.glBindTexture((int)target, (int)texture.getHandle());
        }
    }

    public void setInt(String name, int value) {
        int location = GL20.glGetUniformLocation((int)this.id, (CharSequence)name);
        if (location >= 0) {
            GL20.glUniform1i((int)location, (int)value);
        }
    }

    public void setFloat(String name, float value) {
        int location = GL20.glGetUniformLocation((int)this.id, (CharSequence)name);
        if (location >= 0) {
            GL20.glUniform1f((int)location, (float)value);
        }
    }

    public void setVec2(String name, Vector2f value) {
        int location = GL20.glGetUniformLocation((int)this.id, (CharSequence)name);
        if (location >= 0) {
            GL20.glUniform2f((int)location, (float)value.x, (float)value.y);
        }
    }

    public void setVec3(String name, Vector3f value) {
        int location = GL20.glGetUniformLocation((int)this.id, (CharSequence)name);
        if (location >= 0) {
            GL20.glUniform3f((int)location, (float)value.x, (float)value.y, (float)value.z);
        }
    }

    public void setMat4(String name, Matrix4f value) {
        int location = GL20.glGetUniformLocation((int)this.id, (CharSequence)name);
        if (location >= 0) {
            GL20.glUniformMatrix4fv((int)location, (boolean)false, (float[])value.get(new float[16]));
        }
    }

    public void setMat3(String name, Matrix3f value) {
        int location = GL20.glGetUniformLocation((int)this.id, (CharSequence)name);
        if (location >= 0) {
            GL20.glUniformMatrix3fv((int)location, (boolean)false, (float[])value.get(new float[9]));
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public RessourceLoader getRessourceLoader() {
        return this.ressourceLoader;
    }

    public void setRessourceLoader(RessourceLoader ressourceLoader) {
        this.ressourceLoader = ressourceLoader;
    }

    public void dispose() {
        GL20.glDeleteProgram((int)this.id);
    }
}

