/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.backend.ApplicationContext;
import api.graphics.Camera;
import api.graphics.IObjectController;
import api.graphics.Material;
import api.graphics.Mesh;
import api.graphics.Model;
import api.graphics.ModelInstance;
import api.graphics.PbrMaterial;
import api.graphics.Shader;
import api.graphics.VertexAttributes;
import api.graphics.geometry.MeshBuilder;
import api.utils.ScreenUtils;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Event;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL45;

public class ObjectPositioner
implements IObjectController {
    private ModelInstance target;
    private Camera camera;
    private ModelInstance renderable;
    private PbrMaterial highlightMtl;
    private Mesh hovered;
    private Mesh xArrow;
    private Mesh yArrow;
    private Mesh zArrow;
    private Mesh xyQuad;
    private Mesh yzQuad;
    private Mesh zxQuad;
    private final Vector3f[] mvmntAxis = new Vector3f[2];
    private boolean onDrag;
    private Vector2i offset = new Vector2i();

    public ObjectPositioner(Camera camera) {
        this.camera = camera;
        this.createRenderable();
    }

    @Override
    public boolean handle(Event event) {
        if (this.target == null) {
            return false;
        }
        return IObjectController.super.handle(event);
    }

    private void createRenderable() {
        PbrMaterial xMaterial = new PbrMaterial();
        xMaterial.setAlbedo(new Vector3f(1.0f, 0.0f, 0.0f));
        xMaterial.setOpacity(0.5f);
        PbrMaterial yMaterial = new PbrMaterial();
        yMaterial.setAlbedo(new Vector3f(0.0f, 1.0f, 0.0f));
        yMaterial.setOpacity(0.5f);
        PbrMaterial zMaterial = new PbrMaterial();
        zMaterial.setAlbedo(new Vector3f(0.0f, 0.0f, 1.0f));
        zMaterial.setOpacity(0.5f);
        float radians90 = (float)Math.toRadians(90.0);
        this.xArrow = MeshBuilder.createArrow(xMaterial, new Matrix4f().rotate(-radians90, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
        this.yArrow = MeshBuilder.createArrow(yMaterial, new Matrix4f());
        this.zArrow = MeshBuilder.createArrow(zMaterial, new Matrix4f().rotate(radians90, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)));
        Vector3f v0 = new Vector3f();
        Vector3f v1 = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f v2 = new Vector3f(1.0f, 1.0f, 0.0f);
        Vector3f v3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f[] corners = new Vector3f[]{v0, v1, v2, v3};
        this.xyQuad = MeshBuilder.createQuad(corners, VertexAttributes.POSITION, zMaterial, new Matrix4f().scale(0.5f));
        this.yzQuad = MeshBuilder.createQuad(corners, VertexAttributes.POSITION, xMaterial, new Matrix4f().rotate(-radians90, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)).scale(0.5f));
        this.zxQuad = MeshBuilder.createQuad(corners, VertexAttributes.POSITION, yMaterial, new Matrix4f().rotate(radians90, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)).scale(0.5f));
        Mesh parent = new Mesh(this.xArrow, this.yArrow, this.zArrow, this.xyQuad, this.yzQuad, this.zxQuad);
        parent.setLocalTransform(new Matrix4f().scale(0.2f));
        Model model = new Model(parent);
        this.renderable = new ModelInstance(model);
        this.highlightMtl = new PbrMaterial();
        this.highlightMtl.setAlbedo(new Vector3f(1.0f, 1.0f, 0.0f));
        this.highlightMtl.setMetalness(0.04f);
        this.highlightMtl.setRoughness(1.0f);
    }

    @Override
    public void attachTo(ModelInstance target) {
        this.setTarget(target);
        Vector3f translation = target.getCenter();
        this.renderable.getTransform().setTranslation(translation.x, translation.y, translation.z);
    }

    @Override
    public boolean mouseDown(MouseEvent e) {
        if (this.hovered != null) {
            this.onDrag = true;
            this.offset.set(e.x, e.y);
            if (this.hovered == this.xArrow) {
                this.mvmntAxis[0] = new Vector3f(1.0f, 0.0f, 0.0f);
                this.mvmntAxis[1] = null;
            } else if (this.hovered == this.yArrow) {
                this.mvmntAxis[0] = new Vector3f(0.0f, 1.0f, 0.0f);
                this.mvmntAxis[1] = null;
            } else if (this.hovered == this.zArrow) {
                this.mvmntAxis[0] = new Vector3f(0.0f, 0.0f, -1.0f);
                this.mvmntAxis[1] = null;
            } else if (this.hovered == this.xyQuad) {
                this.mvmntAxis[0] = new Vector3f(1.0f, 0.0f, 0.0f);
                this.mvmntAxis[1] = new Vector3f(0.0f, 1.0f, 0.0f);
            } else if (this.hovered == this.yzQuad) {
                this.mvmntAxis[0] = new Vector3f(0.0f, 1.0f, 0.0f);
                this.mvmntAxis[1] = new Vector3f(0.0f, 0.0f, 1.0f);
            } else if (this.hovered == this.zxQuad) {
                this.mvmntAxis[0] = new Vector3f(0.0f, 0.0f, 1.0f);
                this.mvmntAxis[1] = new Vector3f(1.0f, 0.0f, 0.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseUp(MouseEvent e) {
        this.onDrag = false;
        return false;
    }

    @Override
    public boolean mouseMove(MouseEvent e) {
        if (this.onDrag) {
            return this.mouseDragged(e);
        }
        float z = ScreenUtils.readDepth(e.x, e.y);
        float y = ApplicationContext.getHeight() - e.y;
        Vector3f worldPoint = this.camera.unproject(new Vector3f((float)e.x, y, z), ApplicationContext.getViewport());
        Vector4f modelPoint = new Vector4f((Vector3fc)worldPoint, 1.0f).mul((Matrix4fc)this.renderable.getInversTransform());
        this.hovered = null;
        for (Mesh mesh : this.renderable) {
            if (!this.renderable.getMeshes().get(0).getParts().contains(mesh)) continue;
            mesh.selectFace(new Vector3f(modelPoint.x, modelPoint.y, modelPoint.z));
            if (!mesh.getBoundingBox().contains(new Vector3f(modelPoint.x, modelPoint.y, modelPoint.z), 0.1f)) continue;
            this.hovered = mesh;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        if (this.hovered == null) {
            return false;
        }
        Vector2i delta = new Vector2i(e.x, e.y).sub((Vector2ic)this.offset).mul(1, -1);
        this.offset.set(e.x, e.y);
        this.glideOnPlane(this.target, delta, this.mvmntAxis, this.camera);
        return true;
    }

    private void glideOnPlane(ModelInstance target, Vector2i delta, Vector3f[] mvmntAxis, Camera camera2) {
        Vector3f firstAxis = this.camera.project(mvmntAxis[0], ApplicationContext.getViewport()).normalize();
        Vector3f secondAxis = new Vector3f();
        if (mvmntAxis[1] != null) {
            secondAxis = this.camera.project(mvmntAxis[1], ApplicationContext.getViewport());
        }
        float a = new Vector3f((Vector2ic)delta, 0.0f).dot((Vector3fc)firstAxis) / (firstAxis.length() + 1.0E-6f);
        float b = new Vector3f((Vector2ic)delta, 0.0f).dot((Vector3fc)secondAxis) / secondAxis.length() + 1.0E-6f;
        Vector3f translation = new Vector3f((Vector3fc)mvmntAxis[0]).normalize(a);
        if (mvmntAxis[1] != null) {
            translation.add((Vector3fc)new Vector3f((Vector3fc)mvmntAxis[1]).mul(b));
        }
        target.getTransform().translate((Vector3fc)translation);
        Vector3f center = target.getCenter();
        this.renderable.getTransform().setTranslation(center.x, center.y, center.z);
    }

    @Override
    public void draw(Shader shader, Camera camera) {
        if (this.target == null) {
            return;
        }
        GL45.glDepthFunc((int)519);
        Material original = null;
        if (this.hovered != null) {
            original = this.hovered.getMtl();
            this.hovered.setMtl(this.highlightMtl);
        }
        this.renderable.draw(shader, camera);
        if (original != null) {
            this.hovered.setMtl(original);
        }
        GL45.glDepthFunc((int)513);
    }

    @Override
    public boolean mouseDoubleClick(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseScrolled(MouseEvent e) {
        return false;
    }

    @Override
    public ModelInstance getRenderable() {
        return this.renderable;
    }

    @Override
    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    @Override
    public void drawVertices(Camera camera) {
    }

    @Override
    public void drawSilhouette(Camera camera) {
    }

    @Override
    public ModelInstance getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(ModelInstance instance) {
        this.target = instance;
    }
}

