/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.graphics.Framebuffer;
import api.graphics.Texture;
import org.lwjgl.opengl.GL40;

public class MultiSampledFrameBuffer
extends Framebuffer {
    private int width;
    private int height;
    int samples = 4;
    private Texture colorAttachment;
    private Texture depthAttachment;

    public MultiSampledFrameBuffer(int width, int height, int samples) {
        this.width = width;
        this.height = height;
        this.samples = samples;
        this.init();
    }

    private void init() {
        this.colorAttachment = new Texture();
        this.colorAttachment.setHandle(GL40.glGenTextures());
        GL40.glBindTexture((int)37120, (int)this.colorAttachment.getHandle());
        GL40.glTexImage2DMultisample((int)37120, (int)this.samples, (int)32856, (int)this.width, (int)this.height, (boolean)true);
        this.depthAttachment = new Texture();
        this.depthAttachment.setHandle(GL40.glGenTextures());
        GL40.glBindTexture((int)37120, (int)this.depthAttachment.getHandle());
        GL40.glTexImage2DMultisample((int)37120, (int)this.samples, (int)33191, (int)this.width, (int)this.height, (boolean)true);
        GL40.glBindFramebuffer((int)36160, (int)this.id);
        GL40.glFramebufferTexture2D((int)36160, (int)36064, (int)37120, (int)this.colorAttachment.getHandle(), (int)0);
        GL40.glFramebufferTexture2D((int)36160, (int)36096, (int)37120, (int)this.depthAttachment.getHandle(), (int)0);
        if (GL40.glCheckFramebufferStatus((int)36160) != 36053) {
            throw new RuntimeException("Framebuffer is not complete!");
        }
        GL40.glBindFramebuffer((int)36160, (int)0);
    }

    public void cleanup() {
        super.cleanUp();
        GL40.glDeleteTextures((int)this.colorAttachment.getHandle());
        GL40.glDeleteTextures((int)this.depthAttachment.getHandle());
    }

    public int getSamples() {
        return this.samples;
    }

    public void setSamples(int samples) {
        this.samples = samples;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Texture getColorAttachment() {
        return this.colorAttachment;
    }

    public void setColorAttachment(Texture colorAttachment) {
        this.colorAttachment = colorAttachment;
    }

    public Texture getDepthAttachment() {
        return this.depthAttachment;
    }

    public void setDepthAttachment(Texture depthAttachment) {
        this.depthAttachment = depthAttachment;
    }
}

