/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.graphics.BoundingBox;
import api.graphics.IDisposable;
import api.graphics.Material;
import api.graphics.Mesh;
import api.graphics.PbrMaterial;
import api.graphics.Texture;
import api.graphics.Vertex;
import api.graphics.VertexAttributes;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.assimp.AIColor4D;
import org.lwjgl.assimp.AIFace;
import org.lwjgl.assimp.AIMaterial;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AIScene;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.assimp.Assimp;

public class Model
implements IDisposable {
    private String name;
    private String path;
    private String folder;
    private List<Mesh> meshes = new ArrayList<Mesh>();
    private boolean loaded = false;
    private boolean loadTexture = true;

    public Model(String path) {
        this.path = path;
        this.folder = Paths.get(path, new String[0]).getParent().toString();
    }

    public Model(Mesh ... meshs) {
        Mesh[] meshArray = meshs;
        int n = meshs.length;
        int n2 = 0;
        while (n2 < n) {
            Mesh mesh = meshArray[n2];
            mesh.setupMesh();
            this.meshes.add(mesh);
            ++n2;
        }
        this.calculateModelTransform();
        this.loaded = true;
    }

    public void load(boolean withTextures) {
        this.loadTexture = withTextures;
        this.load();
    }

    public void load() {
        int postProcessFlags = 262216;
        AIScene scene = Assimp.aiImportFile((CharSequence)this.path, (int)postProcessFlags);
        this.process(scene);
        this.loaded = true;
        this.calculateModelTransform();
    }

    private void process(AIScene scene) {
        int i = 0;
        while (i < scene.mNumMeshes()) {
            AIMesh mesh = AIMesh.create((long)scene.mMeshes().get(i));
            this.meshes.add(this.processMesh(mesh, scene));
            ++i;
        }
    }

    Material processMaterial(AIMaterial mtl) {
        float[] roughness;
        int resultRoughness;
        float[] metalness;
        int resultMetalness;
        float[] opacity;
        int opacityResult;
        PbrMaterial pbrMaterial = new PbrMaterial();
        AIColor4D albedoColor = AIColor4D.create();
        int resultAlbedo = Assimp.aiGetMaterialColor((AIMaterial)mtl, (CharSequence)"$clr.diffuse", (int)0, (int)0, (AIColor4D)albedoColor);
        if (resultAlbedo == 0) {
            pbrMaterial.setAlbedo(new Vector3f(albedoColor.r(), albedoColor.g(), albedoColor.b()));
        }
        if ((opacityResult = Assimp.aiGetMaterialFloatArray((AIMaterial)mtl, (CharSequence)"$mat.opacity", (int)0, (int)0, (float[])(opacity = new float[1]), null)) != 0) {
            opacity[0] = 1.0f;
        }
        if ((resultMetalness = Assimp.aiGetMaterialFloatArray((AIMaterial)mtl, (CharSequence)"$mat.metallicFactor", (int)0, (int)0, (float[])(metalness = new float[1]), null)) != 0) {
            metalness[0] = 0.04f;
        }
        if ((resultRoughness = Assimp.aiGetMaterialFloatArray((AIMaterial)mtl, (CharSequence)"$mat.roughnessFactor", (int)0, (int)0, (float[])(roughness = new float[1]), null)) != 0) {
            roughness[0] = 0.5f;
        }
        if (this.loadTexture) {
            int hasRoughnessMap;
            int hasMetallicMap;
            int hasNormal;
            Object pathToImage;
            AIString texturePath = AIString.calloc();
            int hasAlbedo = Assimp.aiGetMaterialTexture((AIMaterial)mtl, (int)1, (int)0, (AIString)texturePath, null, null, null, null, null, null);
            if (hasAlbedo == 0) {
                pathToImage = texturePath.dataString();
                if (!((String)pathToImage).contains(":")) {
                    pathToImage = this.folder + File.separator + (String)pathToImage;
                }
                Texture albedoMap = new Texture((String)pathToImage);
                albedoMap.generate();
                pbrMaterial.setAlbedoMap(albedoMap);
            }
            if ((hasNormal = Assimp.aiGetMaterialTexture((AIMaterial)mtl, (int)6, (int)0, (AIString)texturePath, null, null, null, null, null, null)) == 0) {
                pathToImage = texturePath.dataString();
                if (!((String)pathToImage).contains(":")) {
                    pathToImage = this.folder + File.separator + (String)pathToImage;
                }
                Texture map = new Texture((String)pathToImage);
                map.generate();
                pbrMaterial.setNormalMap(map);
            }
            if ((hasMetallicMap = Assimp.aiGetMaterialTexture((AIMaterial)mtl, (int)15, (int)0, (AIString)texturePath, null, null, null, null, null, null)) == 0) {
                pathToImage = texturePath.dataString();
                if (!((String)pathToImage).contains(":")) {
                    pathToImage = this.folder + File.separator + (String)pathToImage;
                }
                Texture map = new Texture((String)pathToImage);
                map.generate();
                pbrMaterial.setMetalnessMap(map);
            }
            if ((hasRoughnessMap = Assimp.aiGetMaterialTexture((AIMaterial)mtl, (int)16, (int)0, (AIString)texturePath, null, null, null, null, null, null)) == 0) {
                pathToImage = texturePath.dataString();
                if (!((String)pathToImage).contains(":")) {
                    pathToImage = this.folder + File.separator + (String)pathToImage;
                }
                Texture map = new Texture((String)pathToImage);
                map.generate();
                pbrMaterial.setRoughnessMap(map);
            }
        }
        pbrMaterial.setOpacity(opacity[0]);
        pbrMaterial.setRoughness(roughness[0]);
        pbrMaterial.setMetalness(metalness[0]);
        return pbrMaterial;
    }

    Mesh processMesh(AIMesh mesh, AIScene scene) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int attr = VertexAttributes.POSITION;
        if (mesh.mNormals() != null) {
            attr |= VertexAttributes.NORMAL;
        }
        if (mesh.mTextureCoords() != null) {
            attr |= VertexAttributes.TEXCOORDS;
        }
        int i = 0;
        while (i < mesh.mNumVertices()) {
            Vertex vertex = new Vertex();
            Vector3f vector = new Vector3f();
            vector.x = ((AIVector3D)mesh.mVertices().get(i)).x();
            vector.y = ((AIVector3D)mesh.mVertices().get(i)).y();
            vector.z = ((AIVector3D)mesh.mVertices().get(i)).z();
            vertex.setPosition(new Vector3f((Vector3fc)vector));
            if (mesh.mNormals() != null) {
                vector.x = ((AIVector3D)mesh.mNormals().get(i)).x();
                vector.y = ((AIVector3D)mesh.mNormals().get(i)).y();
                vector.z = ((AIVector3D)mesh.mNormals().get(i)).z();
                vertex.setNormal(new Vector3f((Vector3fc)vector));
            }
            if (mesh.mTextureCoords() != null) {
                Vector2f uv = new Vector2f();
                AIVector3D.Buffer uvs = mesh.mTextureCoords(0);
                if (uvs != null) {
                    uv.x = ((AIVector3D)mesh.mTextureCoords(0).get(i)).x();
                    uv.y = ((AIVector3D)mesh.mTextureCoords(0).get(i)).y();
                }
                vertex.setTextCoords(uv);
            }
            vertices.add(vertex);
            ++i;
        }
        i = 0;
        while (i < mesh.mNumFaces()) {
            AIFace face = (AIFace)mesh.mFaces().get(i);
            int j = 0;
            while (j < face.mNumIndices()) {
                indices.add(face.mIndices().get(j));
                ++j;
            }
            ++i;
        }
        AIMaterial material = AIMaterial.create((long)scene.mMaterials().get(mesh.mMaterialIndex()));
        Material mtl = this.processMaterial(material);
        int[] indicesArray = new int[indices.size()];
        int i2 = 0;
        while (i2 < indices.size()) {
            indicesArray[i2] = (Integer)indices.get(i2);
            ++i2;
        }
        return new Mesh(vertices.toArray(new Vertex[0]), indicesArray, 4, attr, mtl, new Matrix4f());
    }

    public List<Mesh> getMeshes() {
        return this.meshes;
    }

    public void setMeshes(List<Mesh> meshes) {
        this.meshes = meshes;
    }

    private void calculateModelTransform() {
        for (Mesh mesh : this.meshes) {
            mesh.calculateModelTransforms();
        }
    }

    public BoundingBox calculateBoundingBox() {
        BoundingBox bbox = null;
        for (Mesh mesh : this.meshes) {
            BoundingBox currentBox = mesh.calculateBoundingBox();
            if (bbox == null) {
                bbox = new BoundingBox(currentBox.getMin(), currentBox.getMax(), currentBox.getTransform());
                continue;
            }
            bbox.extend(currentBox);
        }
        return bbox;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public void dispose() {
        for (Mesh mesh : this.meshes) {
            mesh.dispose();
        }
    }
}

