/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.graphics.geometry.Edge;
import api.graphics.geometry.Triangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MeshUtils {
    public static List<Triangle> selectAdjacentFace(List<Triangle> faces, List<Triangle> space) {
        List<Edge> outerEdges = MeshUtils.findOuterEdges(faces);
        boolean stop = true;
        for (Triangle faceX : space) {
            if (Math.abs(faceX.getNormal().normalize().dot((Vector3fc)faces.get(0).getNormal().normalize()) - 1.0f) > 0.2f) continue;
            Edge[] edgeArray = faceX.getEdges();
            int n = edgeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Edge edgeX = edgeArray[n2];
                if (outerEdges.contains(edgeX)) {
                    faces.add(faceX);
                    stop = false;
                }
                ++n2;
            }
        }
        space.removeAll(faces);
        if (!(stop |= space.isEmpty())) {
            return MeshUtils.selectAdjacentFace(faces, space);
        }
        return faces;
    }

    public static List<Edge> findOuterEdges(List<Triangle> triangles) {
        ArrayList<Edge> outerEdges = new ArrayList<Edge>();
        ArrayList<Edge> sharedEdges = new ArrayList<Edge>();
        int i = 0;
        while (i < triangles.size()) {
            Edge[] edges;
            Edge[] edgeArray = edges = triangles.get(i).getEdges();
            int n = edges.length;
            int n2 = 0;
            while (n2 < n) {
                Edge edgeX = edgeArray[n2];
                boolean shared = false;
                int j = i + 1;
                while (j < triangles.size()) {
                    List<Edge> otherEdges = Arrays.asList(triangles.get(j).getEdges());
                    if (otherEdges.contains(edgeX)) {
                        shared = true;
                        break;
                    }
                    ++j;
                }
                if (shared) {
                    sharedEdges.add(edgeX);
                } else {
                    outerEdges.add(edgeX);
                }
                ++n2;
            }
            ++i;
        }
        outerEdges.removeAll(sharedEdges);
        return outerEdges;
    }

    public static void main(String ... strings) {
        Vector3f v0 = new Vector3f();
        Vector3f v1 = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f v2 = new Vector3f(1.0f, 0.0f, 1.0f);
        Vector3f v3 = new Vector3f(0.0f, 0.0f, 1.0f);
        Triangle tr = new Triangle(v0, v1, v2);
        Triangle tr2 = new Triangle(v3, v0, v2);
        ArrayList<Triangle> mesh = new ArrayList<Triangle>();
        mesh.add(tr2);
        mesh.add(tr);
        List<Edge> outer = MeshUtils.findOuterEdges(mesh);
        System.out.println(outer);
    }
}

