/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.graphics.BoundingBox;
import api.graphics.Camera;
import api.graphics.IDisposable;
import api.graphics.IDrawable;
import api.graphics.Material;
import api.graphics.MeshUtils;
import api.graphics.PbrMaterial;
import api.graphics.Shader;
import api.graphics.Vertex;
import api.graphics.VertexAttributes;
import api.graphics.geometry.Edge;
import api.graphics.geometry.Quad;
import api.graphics.geometry.ShapeDrawer;
import api.graphics.geometry.Triangle;
import api.utils.MathUtilities;
import java.util.ArrayList;
import java.util.List;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL30;

public class Mesh
implements IDisposable,
IDrawable {
    protected int type = 4;
    protected int attributes = VertexAttributes.POSITION;
    protected Vertex[] vertices;
    protected int[] indices;
    protected Material mtl;
    protected final Matrix4f localTransform = new Matrix4f();
    protected final Matrix4f modelTransform = new Matrix4f();
    protected final Matrix4f inverseLocalTransform = new Matrix4f();
    protected final Matrix4f transform = new Matrix4f();
    protected int VAO;
    protected int VBO;
    protected int EBO;
    public List<Mesh> parts = new ArrayList<Mesh>();
    private Vector3f[] corners;
    private List<Edge> silhouetteEdges = new ArrayList<Edge>();
    private List<Triangle> faces = new ArrayList<Triangle>();
    private BoundingBox boundingBox;
    static ShapeDrawer drawer = new ShapeDrawer();

    public Mesh(Mesh ... parts) {
        drawer.prepare();
        this.addParts(parts);
        this.calculateModelTransforms();
    }

    public Mesh(Vertex[] vertices, int[] indices, int type, int attrs, Material mtl, Matrix4f transform) {
        drawer.prepare();
        this.vertices = vertices;
        this.indices = indices;
        this.type = type;
        this.attributes = attrs;
        this.mtl = mtl;
        this.setTransform(transform);
        this.localTransform.set((Matrix4fc)transform);
        this.localTransform.invert(this.inverseLocalTransform);
        this.setupMesh();
    }

    protected float[] prepareVerticesData() {
        int c = 0;
        int hasNormal = Math.min(this.attributes & VertexAttributes.NORMAL, 1);
        int hasTexCoords = Math.min(this.attributes & VertexAttributes.TEXCOORDS, 1);
        int component = 3 + 3 * hasNormal + 2 * hasTexCoords;
        float[] buffer = new float[component * this.vertices.length];
        Vertex[] vertexArray = this.vertices;
        int n = this.vertices.length;
        int n2 = 0;
        while (n2 < n) {
            Vertex vertex = vertexArray[n2];
            buffer[c++] = vertex.getPosition().x;
            buffer[c++] = vertex.getPosition().y;
            buffer[c++] = vertex.getPosition().z;
            if (hasNormal > 0) {
                buffer[c++] = vertex.getNormal().x;
                buffer[c++] = vertex.getNormal().y;
                buffer[c++] = vertex.getNormal().z;
            }
            if (hasTexCoords > 0) {
                buffer[c++] = vertex.getTextCoords().x;
                buffer[c++] = vertex.getTextCoords().y;
            }
            ++n2;
        }
        return buffer;
    }

    public void setupMesh() {
        if (this.vertices == null) {
            return;
        }
        this.VAO = GL30.glGenVertexArrays();
        this.VBO = GL30.glGenBuffers();
        this.EBO = GL30.glGenBuffers();
        GL30.glBindVertexArray((int)this.VAO);
        float[] verticesData = this.prepareVerticesData();
        GL30.glBindBuffer((int)34962, (int)this.VBO);
        GL30.glBufferData((int)34962, (float[])verticesData, (int)35044);
        GL30.glBindBuffer((int)34963, (int)this.EBO);
        GL30.glBufferData((int)34963, (int[])this.indices, (int)35044);
        int hasNormal = Math.min(this.attributes & VertexAttributes.NORMAL, 1);
        int hasTexCoords = Math.min(this.attributes & VertexAttributes.TEXCOORDS, 1);
        int vertexSize = (3 + 3 * hasNormal + 2 * hasTexCoords) * 4;
        int attrIndex = 0;
        int offset = 0;
        GL30.glEnableVertexAttribArray((int)attrIndex);
        GL30.glVertexAttribPointer((int)attrIndex++, (int)3, (int)5126, (boolean)false, (int)vertexSize, (long)offset);
        offset += 3;
        if (hasNormal > 0) {
            GL30.glEnableVertexAttribArray((int)attrIndex);
            GL30.glVertexAttribPointer((int)attrIndex++, (int)3, (int)5126, (boolean)false, (int)vertexSize, (long)(offset * 4));
            offset += 3;
        }
        if (hasTexCoords > 0) {
            GL30.glEnableVertexAttribArray((int)attrIndex);
            GL30.glVertexAttribPointer((int)attrIndex, (int)2, (int)5126, (boolean)false, (int)vertexSize, (long)24L);
        }
        GL30.glBindVertexArray((int)0);
    }

    @Override
    public void draw(Shader shader, Camera camera) {
        if (this.indices != null) {
            shader.setMat4("model", this.transform);
            shader.setMat3("normal", new Matrix4f((Matrix4fc)this.transform).normal().get3x3(new Matrix3f()));
            shader.bindMaterial((PbrMaterial)this.mtl);
            GL30.glBindVertexArray((int)this.VAO);
            GL30.glDrawElements((int)this.type, (int)this.indices.length, (int)5125, (long)0L);
            GL30.glBindVertexArray((int)0);
        }
        if (this.parts != null) {
            for (Mesh part : this.parts) {
                part.draw(shader, camera);
            }
        }
    }

    @Override
    public void drawVertices(Camera camera) {
        drawer.begin(camera);
        drawer.drawPoints(this.getCorners(), 6.0f, new Vector3f(1.0f, 1.0f, 0.0f), this.transform);
        drawer.end();
        if (this.parts != null) {
            for (Mesh part : this.parts) {
                part.drawVertices(camera);
            }
        }
    }

    @Override
    public void drawSilhouette(Camera camera) {
        if (this.indices != null && this.silhouetteEdges != null && camera != null) {
            ArrayList<Vector3f> lines = new ArrayList<Vector3f>();
            Vector3f black = new Vector3f(0.0f, 0.0f, 0.0f);
            for (Edge edge : this.silhouetteEdges) {
                lines.add(edge.getV0());
                lines.add(edge.getV1());
            }
            drawer.begin(camera);
            drawer.drawLines(lines.toArray(new Vector3f[0]), 1.0f, black, this.transform);
            drawer.end();
        }
        if (this.parts != null) {
            for (Mesh part : this.parts) {
                part.drawSilhouette(camera);
            }
        }
    }

    public void calculateTransforms() {
        for (Mesh part : this.parts) {
            part.setTransform(new Matrix4f((Matrix4fc)this.transform).mul((Matrix4fc)part.getLocalTransform()));
            part.calculateTransforms();
        }
    }

    public void calculateModelTransforms() {
        for (Mesh part : this.parts) {
            this.getModelTransform().mul((Matrix4fc)part.getLocalTransform(), part.getModelTransform());
            part.calculateModelTransforms();
        }
    }

    public Triangle selectFace(Vector3f modelPoint) {
        Vector4f meshPoint4 = new Vector4f((Vector3fc)modelPoint, 1.0f).mul((Matrix4fc)new Matrix4f((Matrix4fc)this.localTransform).invert());
        Vector3f meshPoint = new Vector3f(meshPoint4.x, meshPoint4.y, meshPoint4.z);
        for (Triangle triangle : this.getFaces()) {
            if (!triangle.contains(meshPoint)) continue;
            triangle.transform = this.modelTransform;
            return triangle;
        }
        for (Mesh part : this.parts) {
            Triangle selection = part.selectFace(meshPoint);
            if (selection == null) continue;
            return selection;
        }
        return null;
    }

    public List<Triangle> selectFaces(Vector3f modelPoint) {
        Vector4f meshPoint4 = new Vector4f((Vector3fc)modelPoint, 1.0f).mul((Matrix4fc)new Matrix4f((Matrix4fc)this.modelTransform).invert());
        Vector3f meshPoint = new Vector3f(meshPoint4.x, meshPoint4.y, meshPoint4.z);
        ArrayList<Triangle> space = new ArrayList<Triangle>(this.getFaces());
        for (Triangle triangle : space) {
            if (!triangle.contains(meshPoint)) continue;
            ArrayList<Triangle> triangles = new ArrayList<Triangle>();
            triangles.add(triangle);
            space.remove(triangle);
            List<Triangle> result = MeshUtils.selectAdjacentFace(triangles, space);
            for (Triangle face : result) {
                face.transform = this.modelTransform;
            }
            return result;
        }
        for (Mesh part : this.parts) {
            List<Triangle> selection = part.selectFaces(modelPoint);
            if (selection == null) continue;
            return selection;
        }
        return null;
    }

    public Quad selectQuad(Triangle face) {
        Vector3f noraml = face.getNormal();
        ArrayList<Triangle> faces = new ArrayList<Triangle>();
        float epsilon = 0.001f;
        for (Triangle faceX : this.getFaces()) {
            if (!(Math.abs(faceX.getNormal().dot((Vector3fc)noraml) - 1.0f) < epsilon)) continue;
            faces.add(faceX);
        }
        Edge[] edges = face.getEdges();
        new ArrayList();
        for (Triangle faceX : faces) {
            Edge[] edgeArray = faceX.getEdges();
            int n = edgeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Edge edge = edgeArray[n2];
                Edge[] edgeArray2 = edges;
                int n3 = edges.length;
                int n4 = 0;
                while (n4 < n3) {
                    Edge faceEdge = edgeArray2[n4];
                    faceEdge.equals(edge);
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public Vector3f[] getCorners() {
        if (this.corners == null) {
            this.corners = new Vector3f[this.vertices.length];
            int c = 0;
            Vertex[] vertexArray = this.vertices;
            int n = this.vertices.length;
            int n2 = 0;
            while (n2 < n) {
                Vertex vertex = vertexArray[n2];
                this.corners[c++] = vertex.getPosition();
                ++n2;
            }
        }
        return this.corners;
    }

    public List<Triangle> getFaces() {
        if (this.indices != null) {
            if ((this.faces == null || this.faces.isEmpty()) && this.indices != null && this.type == 4) {
                int i = 0;
                while (i < this.indices.length) {
                    Vector3f v0 = new Vector3f((Vector3fc)this.vertices[this.indices[i]].getPosition());
                    Vector3f v1 = new Vector3f((Vector3fc)this.vertices[this.indices[i + 1]].getPosition());
                    Vector3f v2 = new Vector3f((Vector3fc)this.vertices[this.indices[i + 2]].getPosition());
                    this.faces.add(new Triangle(v0, v1, v2));
                    i += 3;
                }
            }
        } else {
            this.faces = new ArrayList<Triangle>();
        }
        return this.faces;
    }

    public BoundingBox calculateBoundingBox() {
        if (this.vertices != null) {
            ArrayList<Vector3f> positions = new ArrayList<Vector3f>();
            Vertex[] vertexArray = this.vertices;
            int n = this.vertices.length;
            int n2 = 0;
            while (n2 < n) {
                Vertex vertex = vertexArray[n2];
                positions.add(vertex.getPosition());
                ++n2;
            }
            Vector3f[] boundaries = MathUtilities.getBoundaries(positions.toArray(new Vector3f[0]));
            this.boundingBox = new BoundingBox(boundaries[0], boundaries[1], this.modelTransform);
        }
        for (Mesh part : this.parts) {
            BoundingBox bbox = part.calculateBoundingBox();
            if (this.boundingBox == null) {
                this.boundingBox = new BoundingBox(bbox.getMin(), bbox.getMax(), bbox.getTransform());
                continue;
            }
            this.boundingBox.extend(bbox);
        }
        return this.boundingBox;
    }

    public void calculateSilhouetteEdges() {
        this.silhouetteEdges.clear();
        for (Triangle triangle : this.getFaces()) {
            Edge[] edgeArray = triangle.getEdges();
            int n = edgeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Edge edge = edgeArray[n2];
                if (!this.silhouetteEdges.contains(edge)) {
                    List<Triangle> triangles = this.findFacesByEdge(edge);
                    boolean silhouette = true;
                    float thresh = (float)Math.cos(Math.toRadians(5.0));
                    if (triangles.size() > 1) {
                        Vector3f normal = triangles.get(0).getNormal();
                        int i = 1;
                        while (i < triangles.size()) {
                            Vector3f current = triangle.getNormal();
                            float dotProd = normal.dot((Vector3fc)current);
                            if (Math.abs(dotProd) > thresh) {
                                silhouette = false;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (silhouette) {
                        this.silhouetteEdges.add(edge);
                    }
                }
                ++n2;
            }
        }
    }

    private List<Triangle> findFacesByEdge(Edge edge) {
        return this.faces.stream().filter(face -> {
            boolean accept = false;
            Edge[] edgeArray = face.getEdges();
            int n = edgeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Edge edgeX = edgeArray[n2];
                if (edgeX.equals(edge)) {
                    accept = true;
                    break;
                }
                ++n2;
            }
            return accept;
        }).toList();
    }

    public void addPart(Mesh part) {
        this.parts.add(part);
    }

    public void addParts(Mesh ... parts) {
        Mesh[] meshArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            Mesh part = meshArray[n2];
            this.parts.add(part);
            ++n2;
        }
    }

    public Vertex[] getVertices() {
        return this.vertices;
    }

    public void setVertices(Vertex[] vertices) {
        this.vertices = vertices;
    }

    public Matrix4f getLocalTransform() {
        return this.localTransform;
    }

    public void setLocalTransform(Matrix4f localTransform) {
        this.localTransform.set((Matrix4fc)localTransform);
    }

    public Matrix4f getTransform() {
        return this.transform;
    }

    public void setTransform(Matrix4f transform) {
        this.transform.set((Matrix4fc)transform);
        transform.invert(this.inverseLocalTransform);
        this.calculateTransforms();
    }

    public Matrix4f getModelTransform() {
        return this.modelTransform;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public List<Mesh> getParts() {
        return this.parts;
    }

    public void setParts(List<Mesh> parts) {
        this.parts = parts;
    }

    public Material getMtl() {
        return this.mtl;
    }

    public void setMtl(Material mtl) {
        this.mtl = mtl;
        for (Mesh part : this.parts) {
            part.setMtl(mtl);
        }
    }

    @Override
    public void dispose() {
        this.mtl.dispose();
        GL30.glDeleteBuffers((int[])new int[]{this.VBO, this.EBO});
        GL30.glDeleteVertexArrays((int)this.VAO);
    }

    public boolean contains(Vector3f modelPoint) {
        return false;
    }

    public void drawFaces(Camera camera, Vector3f vector3f) {
        drawer.begin(camera);
        drawer.drawTrianglesOutlined(this.getFaces().toArray(new Triangle[0]), 2.0f, this.transform, new Vector3f(0.0f, 1.0f, 0.0f));
        drawer.end();
    }

    public Vector3f selectVertex(Vector3f modelPoint) {
        Vector4f meshPoint4 = new Vector4f((Vector3fc)modelPoint, 1.0f).mul((Matrix4fc)new Matrix4f((Matrix4fc)this.modelTransform).invert());
        Vector3f meshPoint = new Vector3f(meshPoint4.x, meshPoint4.y, meshPoint4.z);
        Vector3f[] corners = this.getCorners();
        float epsilon = this.boundingBox.getSize().length() / 10.0f;
        Vector3f selection = null;
        float minDst = Float.MAX_VALUE;
        int i = 1;
        while (i < this.getCorners().length) {
            float currentDst = meshPoint.distanceSquared((Vector3fc)corners[i]);
            if (currentDst < epsilon && currentDst < minDst) {
                selection = corners[i];
                minDst = currentDst;
            }
            ++i;
        }
        return selection;
    }
}

