/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class Camera {
    private Vector3f Position = new Vector3f();
    Vector3f Front = new Vector3f(0.0f, 0.0f, -1.0f);
    Vector3f Up = new Vector3f(0.0f, 1.0f, 0.0f);
    Vector3f Right;
    Vector3f WorldUp;
    float far;
    float near;
    float aspectRatio = 1.0f;
    float Yaw = -90.0f;
    float Pitch = 0.0f;
    float MovementSpeed = 2.5f;
    float MouseSensitivity = 0.1f;
    float Zoom = 90.0f;
    private Matrix4f perspectiveProjection = new Matrix4f();
    private Matrix4f orthoProjection = new Matrix4f();
    boolean orthographic;
    float viewportWidth = 6.0f;

    public Camera(Vector3f position, Vector3f up, float ratio, float yaw, float pitch) {
        this.Position = position;
        this.WorldUp = up;
        this.Yaw = yaw;
        this.Pitch = pitch;
        this.near = 0.5f;
        this.far = 20.0f;
        this.aspectRatio = ratio;
        this.updateCameraVectors();
    }

    public Matrix4f GetViewMatrix() {
        Vector3f target = new Vector3f((Vector3fc)this.Position).add((Vector3fc)this.Front);
        return new Matrix4f().lookAt((Vector3fc)this.Position, (Vector3fc)target, (Vector3fc)this.Up);
    }

    public Matrix4f GetProjectionMatrix() {
        if (this.orthographic) {
            float w = (float)((double)this.viewportWidth * Math.sin(Math.toRadians(this.Zoom / 2.0f)));
            float h = w / this.aspectRatio;
            this.orthoProjection.identity().ortho(-w, w, -h, h, 0.0f, this.far);
            return this.orthoProjection;
        }
        this.perspectiveProjection.identity().perspective((float)Math.toRadians(this.Zoom / 2.0f), this.aspectRatio, this.near, this.far);
        return this.perspectiveProjection;
    }

    public void move(Camera_Movement direction, float deltaTime) {
        float velocity = this.MovementSpeed * deltaTime;
        System.out.println("velocity: " + velocity);
        if (direction == Camera_Movement.FORWARD) {
            this.Position.add((Vector3fc)new Vector3f((Vector3fc)this.Front).mul(velocity));
        }
        if (direction == Camera_Movement.BACKWARD) {
            this.Position.add((Vector3fc)new Vector3f((Vector3fc)this.Front).mul(-velocity));
        }
        if (direction == Camera_Movement.LEFT) {
            this.Position.add((Vector3fc)new Vector3f((Vector3fc)this.Right).mul(-velocity));
        }
        if (direction == Camera_Movement.RIGHT) {
            this.Position.add((Vector3fc)new Vector3f((Vector3fc)this.Right).mul(velocity));
        }
    }

    public void updateCameraVectors() {
        Vector3f front = new Vector3f();
        front.x = (float)(Math.cos(Math.toRadians(this.Yaw)) * Math.cos(Math.toRadians(this.Pitch)));
        front.y = (float)Math.sin(Math.toRadians(this.Pitch));
        front.z = (float)(Math.sin(Math.toRadians(this.Yaw)) * Math.cos(Math.toRadians(this.Pitch)));
        this.Front = front.normalize();
        this.Right = new Vector3f((Vector3fc)this.Front).cross((Vector3fc)this.WorldUp).normalize();
        this.Up = new Vector3f((Vector3fc)this.Right).cross((Vector3fc)this.Front).normalize();
    }

    public Vector3f getPosition() {
        return this.Position;
    }

    public void setPosition(Vector3f position) {
        this.Position = position;
    }

    public Vector3f project(Vector3f worldPoint, float[] viewport) {
        Matrix4f vp = new Matrix4f().set((Matrix4fc)this.GetProjectionMatrix()).mul((Matrix4fc)this.GetViewMatrix());
        Vector4f clipSpacePoint = new Vector4f((Vector3fc)worldPoint, 1.0f).mul((Matrix4fc)vp);
        clipSpacePoint.div(clipSpacePoint.w);
        clipSpacePoint.add(1.0f, 1.0f, 1.0f, 0.0f).mul(0.5f, 0.5f, 0.5f, 1.0f);
        float screenX = clipSpacePoint.x * viewport[2] + viewport[0];
        float screenY = clipSpacePoint.y * viewport[3] + viewport[1];
        return new Vector3f(screenX, screenY, clipSpacePoint.z);
    }

    public Vector3f unproject(Vector3f screenPoint, float[] viewport) {
        float x = 2.0f * (screenPoint.x - viewport[0]) / viewport[2] - 1.0f;
        float y = 2.0f * (screenPoint.y - viewport[1]) / viewport[3] - 1.0f;
        float z = 2.0f * screenPoint.z - 1.0f;
        Vector4f clipSpacePoint = new Vector4f(x, y, z, 1.0f);
        Matrix4f inverseProjection = new Matrix4f();
        this.GetProjectionMatrix().mul((Matrix4fc)this.GetViewMatrix()).invert(inverseProjection);
        clipSpacePoint.mul((Matrix4fc)inverseProjection);
        Vector3f worldCoords = new Vector3f(clipSpacePoint.x, clipSpacePoint.y, clipSpacePoint.z).mul(1.0f / clipSpacePoint.w + 1.0E-6f);
        return worldCoords;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public float getZoom() {
        return this.Zoom;
    }

    public void setZoom(float zoom) {
        this.Zoom = Math.max(1.0f, Math.min(179.0f, zoom));
        System.out.println(this.Zoom);
    }

    public float getMovementSpeed() {
        return this.MovementSpeed;
    }

    public void setMovementSpeed(float movementSpeed) {
        this.MovementSpeed = movementSpeed;
    }

    public float getMouseSensitivity() {
        return this.MouseSensitivity;
    }

    public void setMouseSensitivity(float mouseSensitivity) {
        this.MouseSensitivity = mouseSensitivity;
    }

    public float getYaw() {
        return this.Yaw;
    }

    public void setYaw(float yaw) {
        this.Yaw = yaw;
    }

    public float getPitch() {
        return this.Pitch;
    }

    public void setPitch(float pitch) {
        this.Pitch = Math.min(89.0f, Math.max(pitch, -89.0f));
    }

    public void lookAt(Vector3f target) {
        Vector3f viewDir = new Vector3f((Vector3fc)target).sub((Vector3fc)this.Position).normalize();
        this.setPitch((float)Math.toDegrees(Math.asin(viewDir.y)));
        this.Yaw = (float)Math.toDegrees(Math.atan2(viewDir.z, viewDir.x));
        this.updateCameraVectors();
    }

    public boolean isOrthographic() {
        return this.orthographic;
    }

    public void setOrthographic(boolean orthographic) {
        this.orthographic = orthographic;
    }

    public Vector3f getFront() {
        return new Vector3f((Vector3fc)this.Front);
    }

    public Vector3f getRight() {
        return new Vector3f((Vector3fc)this.Right);
    }

    public Vector3f getUp() {
        return new Vector3f((Vector3fc)this.Up);
    }

    public float getNearQuadHeight() {
        return (float)Math.tan(Math.toRadians(this.Zoom / 2.0f)) * this.near;
    }

    public float getNearQuadWidth() {
        return this.getNearQuadHeight() * this.aspectRatio;
    }

    public static enum CAMERA_MODE {
        FLY,
        ORBIT;

    }

    public static enum Camera_Movement {
        FORWARD,
        BACKWARD,
        LEFT,
        RIGHT;

    }

    public static enum PROJECTION_MODE {
        ORTHOGRAPHIC,
        PERSPECTIVE;

    }
}

