/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.graphics.Camera;
import api.graphics.IDrawable;
import api.graphics.Mesh;
import api.graphics.ModelInstance;
import api.graphics.Shader;
import api.utils.MathUtilities;
import java.util.ArrayList;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL40;

public class BoundingBox
implements IDrawable {
    private Vector3f[] corners = new Vector3f[8];
    private Vector3f min = new Vector3f(Float.MAX_VALUE);
    private Vector3f max = new Vector3f(Float.MIN_VALUE);
    private Vector3f center;
    private int VAO;
    private Vector3f color;
    private Matrix4f transform;
    private Matrix4f inverseTransform;

    public BoundingBox(Vector3f min, Vector3f max, Matrix4f transform) {
        this.min = min;
        this.max = max;
        this.transform = transform;
        this.inverseTransform = new Matrix4f((Matrix4fc)transform).invert();
        this.calculateCorners();
    }

    public void extend(BoundingBox other) {
        ArrayList<Vector3f> localCorners = new ArrayList<Vector3f>();
        int i = 0;
        while (i < 8) {
            Vector4f local = new Vector4f((Vector3fc)other.getCorner(i), 1.0f).mul((Matrix4fc)other.getTransform()).mul((Matrix4fc)this.inverseTransform);
            localCorners.add(new Vector3f(local.x, local.y, local.z));
            ++i;
        }
        localCorners.add(this.min);
        localCorners.add(this.max);
        Vector3f[] newBoundaries = MathUtilities.getBoundaries(localCorners.toArray(new Vector3f[0]));
        this.min = newBoundaries[0];
        this.max = newBoundaries[1];
        this.calculateCorners();
    }

    public static BoundingBox calculateBoundingBox(Mesh mesh) {
        return null;
    }

    public static BoundingBox calculateBoundingBox(ModelInstance model) {
        return null;
    }

    public Vector3f getCorner(int index) {
        return this.corners[index];
    }

    public Vector3f getCenter() {
        Vector3f boxCenter = new Vector3f((Vector3fc)this.min).add((Vector3fc)this.max).mul(0.5f);
        Vector4f center = new Vector4f((Vector3fc)boxCenter, 1.0f).mul((Matrix4fc)this.transform);
        return new Vector3f(center.x, center.y, center.z);
    }

    public Vector3f getSize() {
        return new Vector3f((Vector3fc)this.max).sub((Vector3fc)this.min);
    }

    public String toString() {
        return "BoundingBox [min=" + String.valueOf(this.min) + ", max=" + String.valueOf(this.max) + "]";
    }

    @Override
    public void draw(Shader shader, Camera camera) {
        if (this.VAO == 0) {
            this.createRenderingData();
        }
        GL30.glBindVertexArray((int)this.VAO);
        GL11.glDrawElements((int)1, (int)24, (int)5123, (long)0L);
        GL30.glBindVertexArray((int)0);
    }

    public void calculateCorners() {
        Vector3f halfSize = this.getSize().mul(0.5f);
        Vector3f center = this.getCenter();
        this.corners[0] = new Vector3f((Vector3fc)center).add((Vector3fc)new Vector3f((Vector3fc)halfSize).mul(-1.0f, -1.0f, -1.0f));
        this.corners[1] = new Vector3f((Vector3fc)center).add((Vector3fc)new Vector3f((Vector3fc)halfSize).mul(-1.0f, -1.0f, 1.0f));
        this.corners[2] = new Vector3f((Vector3fc)center).add((Vector3fc)new Vector3f((Vector3fc)halfSize).mul(-1.0f, 1.0f, -1.0f));
        this.corners[3] = new Vector3f((Vector3fc)center).add((Vector3fc)new Vector3f((Vector3fc)halfSize).mul(-1.0f, 1.0f, 1.0f));
        this.corners[4] = new Vector3f((Vector3fc)center).add((Vector3fc)new Vector3f((Vector3fc)halfSize).mul(1.0f, -1.0f, -1.0f));
        this.corners[5] = new Vector3f((Vector3fc)center).add((Vector3fc)new Vector3f((Vector3fc)halfSize).mul(1.0f, -1.0f, 1.0f));
        this.corners[6] = new Vector3f((Vector3fc)center).add((Vector3fc)new Vector3f((Vector3fc)halfSize).mul(1.0f, 1.0f, -1.0f));
        this.corners[7] = new Vector3f((Vector3fc)center).add((Vector3fc)new Vector3f((Vector3fc)halfSize).mul(1.0f, 1.0f, 1.0f));
    }

    private void createRenderingData() {
        if (this.corners == null) {
            this.calculateCorners();
        }
        float[] verticesData = new float[24];
        int c = 0;
        int i = 0;
        while (i < 8) {
            verticesData[c++] = this.corners[i].x;
            verticesData[c++] = this.corners[i].y;
            verticesData[c++] = this.corners[i].z;
            ++i;
        }
        short[] sArray = new short[24];
        sArray[0] = 3;
        sArray[1] = 7;
        sArray[2] = 7;
        sArray[3] = 6;
        sArray[4] = 6;
        sArray[5] = 2;
        sArray[6] = 2;
        sArray[7] = 3;
        sArray[8] = 1;
        sArray[9] = 5;
        sArray[10] = 5;
        sArray[11] = 4;
        sArray[12] = 4;
        sArray[15] = 1;
        sArray[16] = 1;
        sArray[17] = 3;
        sArray[18] = 5;
        sArray[19] = 7;
        sArray[20] = 4;
        sArray[21] = 6;
        sArray[23] = 2;
        short[] indices = sArray;
        this.VAO = GL40.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.VAO);
        int vbo = GL40.glGenBuffers();
        int ebo = GL40.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vbo);
        GL15.glBufferData((int)34962, (float[])verticesData, (int)35044);
        GL15.glBindBuffer((int)34963, (int)ebo);
        GL15.glBufferData((int)34963, (short[])indices, (int)35044);
        int vertexSize = 12;
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)vertexSize, (long)0L);
        GL30.glBindVertexArray((int)0);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public boolean contains(Vector3f localPoint, float extension) {
        Vector4f boxPoint4 = new Vector4f((Vector3fc)localPoint, 1.0f).mul((Matrix4fc)this.inverseTransform);
        Vector3f point = new Vector3f(boxPoint4.x, boxPoint4.y, boxPoint4.z);
        Vector3f center = this.getCenter();
        Vector3f radius = this.getSize().add((Vector3fc)new Vector3f(extension)).mul(0.5f);
        if (point.distanceSquared((Vector3fc)center) > radius.lengthSquared()) {
            return false;
        }
        Vector3f extendedMin = new Vector3f((Vector3fc)center).sub((Vector3fc)radius);
        Vector3f extendedMax = new Vector3f((Vector3fc)center).add((Vector3fc)radius);
        if (point.x > extendedMax.x || point.x < extendedMin.x) {
            return false;
        }
        if (point.y > extendedMax.y || point.y < extendedMin.y) {
            return false;
        }
        return !(point.z > extendedMax.z) && !(point.z < extendedMin.z);
    }

    public boolean wrap(BoundingBox other) {
        return false;
    }

    public Vector3f[] getCorners() {
        if (this.corners == null) {
            this.calculateCorners();
        }
        return this.corners;
    }

    public Vector3f getMin() {
        return this.min;
    }

    public Vector3f getMax() {
        return this.max;
    }

    public Matrix4f getTransform() {
        return this.transform;
    }

    public void setTransform(Matrix4f transform) {
        this.transform = transform;
        this.inverseTransform = new Matrix4f((Matrix4fc)transform).invert();
    }

    public BoundingBox cpy() {
        return new BoundingBox(new Vector3f((Vector3fc)this.min), new Vector3f((Vector3fc)this.max), new Matrix4f((Matrix4fc)this.transform));
    }

    @Override
    public void drawVertices(Camera camera) {
    }

    @Override
    public void drawSilhouette(Camera camera) {
    }
}

