/*
 * Decompiled with CFR 0.152.
 */
package api.backend;

import api.backend.ApplicationContext;
import api.graphics.BlitFrameBuffer;
import api.graphics.MultiSampledFrameBuffer;
import api.graphics.Scene;
import api.graphics.Shader;
import api.graphics.geometry.ScreenQuad;
import api.input.InputMultiplexer;
import java.nio.ByteBuffer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.joml.Vector3f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL45;
import org.lwjgl.stb.STBImageWrite;

public class SWTGLApplication {
    private final GLCanvas canvas;
    private final Scene scene;
    private MultiSampledFrameBuffer msFrameBuffer;
    private BlitFrameBuffer blitFrameBuffer;
    private Shader screenShader;
    private Shader blitShader;
    private ScreenQuad quad;
    private Vector3f bgColor = new Vector3f(1.0f, 1.0f, 1.0f);
    private long lastFrame;

    public SWTGLApplication(GLCanvas canvas, Scene scene) {
        this.canvas = canvas;
        this.scene = scene;
        this.createGlObjects();
    }

    public void createGlObjects() {
        this.quad = new ScreenQuad();
        this.blitShader = new Shader("C:\\ProgramData\\supercad\\shaders\\blit shaders\\vertex.glsl", "C:\\ProgramData\\supercad\\shaders\\blit shaders\\frag.glsl");
        this.screenShader = new Shader("C:\\ProgramData\\supercad\\shaders\\texture shader\\vertex.glsl", "C:\\ProgramData\\supercad\\shaders\\texture shader\\frag.glsl");
        this.canvas.addListener(9, event -> this.run());
        this.canvas.addListener(11, event -> this.resize(this.canvas.getSize().x, this.canvas.getSize().y));
        this.registerInputListener();
        Point canvasSize = this.canvas.getSize();
        if (canvasSize.x > 1 && canvasSize.y > 1) {
            this.msFrameBuffer = new MultiSampledFrameBuffer(this.canvas.getSize().x, this.canvas.getSize().y, 4);
            this.blitFrameBuffer = new BlitFrameBuffer(this.canvas.getSize().x, this.canvas.getSize().y);
        }
        Runnable periodicTask = new Runnable(){

            @Override
            public void run() {
                if (!SWTGLApplication.this.canvas.isDisposed()) {
                    Event paintEvent = new Event();
                    paintEvent.type = 9;
                    SWTGLApplication.this.canvas.notifyListeners(9, paintEvent);
                    SWTGLApplication.this.canvas.getDisplay().timerExec(41, (Runnable)this);
                }
            }
        };
        this.canvas.getDisplay().asyncExec(periodicTask);
    }

    private void registerInputListener() {
        this.canvas.addListener(37, event -> {
            boolean bl = InputMultiplexer.getInstance().handle(event);
        });
        this.canvas.addListener(8, event -> {
            boolean bl = InputMultiplexer.getInstance().handle(event);
        });
        this.canvas.addListener(3, event -> {
            boolean bl = InputMultiplexer.getInstance().handle(event);
        });
        this.canvas.addListener(4, event -> {
            boolean bl = InputMultiplexer.getInstance().handle(event);
        });
        this.canvas.addListener(5, event -> {
            boolean bl = InputMultiplexer.getInstance().handle(event);
        });
        this.canvas.addListener(1, event -> {
            boolean bl = InputMultiplexer.getInstance().handle(event);
        });
        this.canvas.addListener(2, event -> {
            boolean bl = InputMultiplexer.getInstance().handle(event);
        });
    }

    public void run() {
        long currentFrame = System.currentTimeMillis();
        long delta = currentFrame - this.lastFrame;
        GL11.glEnable((int)32925);
        this.msFrameBuffer.bind();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL45.glBlendFunc((int)770, (int)771);
        Point size = this.canvas.getSize();
        GL45.glViewport((int)0, (int)0, (int)size.x, (int)size.y);
        GL45.glClearColor((float)this.bgColor.x, (float)this.bgColor.y, (float)this.bgColor.z, (float)1.0f);
        GL45.glClear((int)16640);
        this.scene.render(delta);
        this.blitFrameBuffer.bind();
        GL11.glDisable((int)2929);
        this.blitShader.use();
        GL45.glClearColor((float)this.bgColor.x, (float)this.bgColor.y, (float)this.bgColor.z, (float)1.0f);
        GL45.glClear((int)16384);
        this.blitShader.setSampler2D(37120, "colorAttachment", this.msFrameBuffer.getColorAttachment(), 0);
        this.blitShader.setSampler2D(37120, "depthAttachment", this.msFrameBuffer.getDepthAttachment(), 1);
        this.blitShader.setInt("samples", 4);
        this.quad.draw(this.blitShader, null);
        GL45.glBindFramebuffer((int)36160, (int)0);
        GL11.glDisable((int)2929);
        GL45.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL45.glClear((int)16384);
        this.screenShader.use();
        this.screenShader.setSampler2D(3553, "screenTexture", this.blitFrameBuffer.getColorSampler(), 0);
        this.quad.draw(this.screenShader, null);
        this.canvas.swapBuffers();
        this.lastFrame = currentFrame;
    }

    public void resize(int width, int height) {
        GL45.glViewport((int)0, (int)0, (int)width, (int)height);
        ApplicationContext.setViewport(0.0f, 0.0f, width, height);
        if (this.msFrameBuffer != null) {
            this.msFrameBuffer.cleanup();
            this.blitFrameBuffer.cleanUp();
        }
        this.msFrameBuffer = new MultiSampledFrameBuffer(this.canvas.getSize().x, this.canvas.getSize().y, 4);
        this.blitFrameBuffer = new BlitFrameBuffer(this.canvas.getSize().x, this.canvas.getSize().y);
        this.scene.resize(width, height);
    }

    public Scene getScene() {
        return this.scene;
    }

    public BlitFrameBuffer getBlitFrameBuffer() {
        return this.blitFrameBuffer;
    }

    public void setBlitFrameBuffer(BlitFrameBuffer blitFrameBuffer) {
        this.blitFrameBuffer = blitFrameBuffer;
    }

    public void saveTextureToFile(int width, int height) {
        FileDialog fileDialog = new FileDialog(this.canvas.getShell());
        String path = fileDialog.open();
        if (path != null) {
            int textureId = this.blitFrameBuffer.getColorSampler().getHandle();
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
            GL45.glGetTextureImage((int)textureId, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
            ByteBuffer flippedBuffer = BufferUtils.createByteBuffer((int)buffer.capacity());
            int y = 0;
            while (y < height) {
                int srcPos = (height - y - 1) * width * 4;
                int dstPos = y * width * 4;
                int x = 0;
                while (x < width * 4) {
                    flippedBuffer.put(dstPos + x, buffer.get(srcPos + x));
                    ++x;
                }
                ++y;
            }
            if (!STBImageWrite.stbi_write_png((CharSequence)path, (int)width, (int)height, (int)4, (ByteBuffer)flippedBuffer, (int)(width * 4))) {
                System.err.println("Failed to save texture to file: " + path);
            }
        }
    }
}

