/*
 * Decompiled with CFR 0.152.
 */
package org.frs.debitage.engine.core.evalutor;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

public class Equation {
    private String key = "";
    private String expr = "";
    private String calculation = "";
    private String runexp = "";
    private double evaluation = 0.0;
    private boolean evaluated = false;
    public static final String CALCULATION_AUTO = "auto";
    public static final String CALCULATION_MANUAL = "manual";
    public static final String CALCULATION_FIRST_AUTO = "firstauto";

    public Equation(String a, String b, String c) {
        this.key = a;
        this.expr = b;
        this.calculation = c == null || c.isEmpty() ? CALCULATION_AUTO : c;
        this.runexp = this.expr;
    }

    public String getKey() {
        return this.key;
    }

    public static Equation FIND_EQUATION(String depvar, ArrayList<Equation> debitage) {
        if (depvar == null) {
            return null;
        }
        for (Equation t : debitage) {
            if (!t.key.equals(depvar)) continue;
            return t;
        }
        return null;
    }

    public void resolve(ScriptEngine engine, ArrayList<Equation> equations, ArrayList<String> dependencystack) throws GeometricEngineException {
        String lastdata = null;
        while (!this.isResolved()) {
            String mydata = this.getRunexp();
            if (lastdata != null && lastdata.equals(mydata)) {
                throw new GeometricEngineException(String.valueOf(this.getKey()) + " cannot be resolved with expression " + this.expr);
            }
            lastdata = mydata;
            Pattern pattern = Pattern.compile("@\\w*\\.\\w*@");
            Matcher matcher = pattern.matcher(mydata);
            ArrayList<String> dependendvars = new ArrayList<String>();
            while (matcher.find()) {
                dependendvars.add(mydata.substring(matcher.start(), matcher.end()));
            }
            for (String depvar : dependendvars) {
                if (dependencystack.contains(depvar)) {
                    throw new GeometricEngineException("Inifinite dependency loop " + depvar + " in equation " + this.key + " = " + this.expr);
                }
                dependencystack.add(depvar);
                Equation tdepndend = Equation.FIND_EQUATION(depvar, equations);
                if (tdepndend == null) {
                    throw new GeometricEngineException("Symbol not found " + depvar + " in equation " + this.key + " = " + this.expr);
                }
                if (tdepndend.isResolved()) {
                    this.filldependency(depvar, tdepndend.getEvaluation(engine));
                } else {
                    tdepndend.resolve(engine, equations, dependencystack);
                    this.filldependency(depvar, tdepndend.getEvaluation(engine));
                }
                dependencystack.remove(depvar);
            }
        }
        this.evaluate(engine);
    }

    public boolean isResolved() {
        return !this.runexp.contains("@");
    }

    public void filldependency(String s, double value) {
        this.runexp = this.runexp.replaceAll(s, "" + value);
    }

    public void evaluate(ScriptEngine engine) throws GeometricEngineException {
        try {
            this.evaluation = new Double(engine.eval(this.runexp).toString());
            this.evaluated = true;
        }
        catch (ScriptException e) {
            e.printStackTrace();
            throw new GeometricEngineException("Evaluation expression " + this.expr + " par " + this.runexp + " is impossible");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeometricEngineException("Evaluation expression " + this.expr + " par " + this.runexp + " is impossible");
        }
    }

    public Double getEvaluation(ScriptEngine engine) throws GeometricEngineException {
        if (engine == null) {
            return this.evaluation;
        }
        if (this.evaluated) {
            return this.evaluation;
        }
        this.evaluate(engine);
        this.evaluated = true;
        return this.evaluation;
    }

    public String getRunexp() {
        return this.runexp;
    }

    public void reset() {
        this.runexp = this.expr;
        this.evaluated = false;
    }

    public boolean isEvaluated() {
        return this.evaluated;
    }

    public String getExpr() {
        return this.expr;
    }

    public boolean isDependentTo(String key) {
        return this.expr.contains(key);
    }

    public void setEvaluation(double value) {
        this.runexp = "" + value;
        this.evaluated = true;
        this.evaluation = value;
    }

    public void setExpr(String expr) {
        this.expr = expr;
        this.evaluated = false;
    }

    public void printEvaluation() {
    }

    public String toString() {
        return String.valueOf(this.key) + " : " + this.expr;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

