/*
 * Decompiled with CFR 0.152.
 */
package com.sandmonkey.ttf_renderer.api;

import api.backend.ApplicationContext;
import com.sandmonkey.ttf_renderer.api.FreeTypeFont;
import com.sandmonkey.ttf_renderer.api.Glyph;
import java.util.ArrayList;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL45;

public class TextRenderer {
    private int VAO;
    private int VBO;

    public TextRenderer() {
        this.create();
    }

    public void create() {
        float[] buffer = new float[1500];
        this.VAO = GL45.glGenVertexArrays();
        this.VBO = GL45.glGenBuffers();
        GL45.glBindVertexArray((int)this.VAO);
        GL45.glBindBuffer((int)34962, (int)this.VBO);
        GL45.glBufferData((int)34962, (float[])buffer, (int)35048);
        GL45.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)20, (long)0L);
        GL45.glEnableVertexAttribArray((int)1);
        GL20.glVertexAttribPointer((int)1, (int)3, (int)5126, (boolean)false, (int)20, (long)8L);
        GL45.glBindBuffer((int)34962, (int)0);
        GL45.glBindVertexArray((int)0);
    }

    public void render(FreeTypeFont font, String text, float x, float y, float scale, float rotation, Vector3f color) {
        FreeTypeFont.getShader().use();
        FreeTypeFont.getShader().setVec3("textColor", color);
        float[] viewport = ApplicationContext.getViewport();
        Matrix4f projection = new Matrix4f().ortho2D(0.0f, viewport[2], 0.0f, viewport[3]);
        FreeTypeFont.getShader().setMat4("projection", projection);
        GL45.glBindVertexArray((int)this.VAO);
        GL45.glBindTexture((int)35866, (int)font.getTextureArray());
        ArrayList<float[]> textVertices = new ArrayList<float[]>();
        int cursorX = 0;
        int c = 0;
        while (c < text.length()) {
            char character = text.charAt(c);
            Glyph ch = font.getChar(character);
            float xpos = cursorX + ch.getBearing().x;
            float ypos = -(ch.getSize().y - ch.getBearing().y);
            float w = ch.getSize().x;
            float h = ch.getSize().y;
            Vector3f region = ch.getRegion();
            float[] vertices = new float[]{xpos, ypos + h, 0.0f, 0.0f, region.z, xpos, ypos, 0.0f, region.y, region.z, xpos + w, ypos, region.x, region.y, region.z, xpos, ypos + h, 0.0f, 0.0f, region.z, xpos + w, ypos, region.x, region.y, region.z, xpos + w, ypos + h, region.x, 0.0f, region.z};
            textVertices.add(vertices);
            cursorX += ch.getAdvance() >> 6;
            ++c;
        }
        int counter = 0;
        float[] buffer = new float[30 * text.length()];
        for (float[] array : textVertices) {
            int i = 0;
            while (i < array.length) {
                buffer[counter++] = array[i];
                ++i;
            }
        }
        Matrix4f model = new Matrix4f().translate(x - (float)cursorX / 2.0f, y, 0.0f).translate((float)cursorX / 2.0f, 0.0f, 0.0f).rotate((float)Math.toRadians(rotation), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)).translate((float)(-cursorX) / 2.0f, 0.0f, 0.0f).scale(scale);
        FreeTypeFont.getShader().setMat4("model", model);
        GL45.glBindBuffer((int)34962, (int)this.VBO);
        GL45.glBufferSubData((int)34962, (long)0L, (float[])buffer);
        GL45.glBindBuffer((int)34962, (int)0);
        GL45.glDepthFunc((int)519);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL45.glDrawArrays((int)4, (int)0, (int)(6 * text.length()));
        GL45.glBindVertexArray((int)0);
        GL45.glBindTexture((int)35866, (int)0);
        GL45.glDepthFunc((int)515);
    }
}

