/*
 * Decompiled with CFR 0.152.
 */
package com.sandmonkey.viewer3d.parts;

import api.graphics.Model;
import com.sandmonkey.viewer3d.api.ui.RenderingCanvas;
import com.sandmonkey.viewer3d.internal.ModelViewer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ViewerPart {
    private RenderingCanvas canvas;
    private ModelViewer modelViewer;

    @PostConstruct
    public void createControl(Composite parent) {
        this.canvas = new RenderingCanvas(parent, 360, 360);
        this.modelViewer = new ModelViewer();
        this.canvas.setScene(this.modelViewer);
        this.canvas.run();
    }

    @Inject
    @Optional
    public void onPreviewModelEvent(@EventTopic(value="PREVIEW_MODEL") Object data) {
        HashMap map = (HashMap)data;
        String modelPath = (String)map.get("value");
        boolean hasAddons = (Boolean)map.get("has_addons");
        HashMap<Model, Matrix4f[]> addons = new HashMap<Model, Matrix4f[]>();
        if (hasAddons) {
            addons.putAll(this.loadAddons(modelPath));
        }
        Object dims = map.get("size");
        Vector3f size = new Vector3f();
        if (dims != null) {
            try {
                size.x = ((Float)Array.get(dims, 0)).floatValue();
                size.y = ((Float)Array.get(dims, 1)).floatValue();
                size.z = ((Float)Array.get(dims, 2)).floatValue();
            }
            catch (Exception exception) {
                size.set(1.0f);
            }
        }
        Model model = new Model(modelPath);
        Display.findDisplay((Thread)this.canvas.getThread()).asyncExec(() -> {
            model.load(false);
            this.modelViewer.setDims(size);
            this.modelViewer.setAddons(addons);
            this.modelViewer.setModel3D(model);
        });
    }

    public HashMap<Model, Matrix4f[]> loadAddons(String modelPath) {
        File file = new File(modelPath);
        File[] folders = file.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        FileFilter dotobjFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".obj");
            }
        };
        FileFilter transformFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".txt");
            }
        };
        HashMap<Model, Matrix4f[]> instances = new HashMap<Model, Matrix4f[]>();
        File[] fileArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            try {
                File modelFile = folder.listFiles(dotobjFilter)[0];
                File transformFile = folder.listFiles(transformFilter)[0];
                Model model = new Model(modelFile.getAbsolutePath());
                Matrix4f[] transforms = ViewerPart.readTransformsFromFile(transformFile);
                instances.put(model, transforms);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return instances;
    }

    public static Matrix4f[] readTransformsFromFile(File file) {
        ArrayList<Matrix4f> transforms = new ArrayList<Matrix4f>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file.getAbsolutePath()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    line = line.replaceAll("[\\[\\]]", "").trim();
                    String[] parts = line.split(",\\s*");
                    float[] floatArray = new float[parts.length];
                    int i = 0;
                    while (i < parts.length) {
                        floatArray[i] = Float.parseFloat(parts[i]);
                        ++i;
                    }
                    transforms.add(new Matrix4f(floatArray[0], floatArray[1], floatArray[2], floatArray[3], floatArray[4], floatArray[5], floatArray[6], floatArray[7], floatArray[8], floatArray[9], floatArray[10], floatArray[11], floatArray[12], floatArray[13], floatArray[14], floatArray[15]));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return transforms.toArray(new Matrix4f[0]);
    }

    @PreDestroy
    public void dispose() {
    }
}

