/*
 * Decompiled with CFR 0.152.
 */
package com.sandmonkey.viewer3d.api.ui;

import api.graphics.IScene;
import api.input.SWTEventAdapter;
import com.sandmonkey.viewer3d.api.ui.RenderingTask;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

public class RenderingCanvas {
    private IScene scene;
    private GLCanvas canvas;
    private SWTEventAdapter eventAdapter;
    public static boolean render = true;
    private Thread thread;

    public RenderingCanvas(Composite parent, int width, int height) {
        this.createCanvas(parent, width, height);
    }

    private void createCanvas(Composite parent, int width, int height) {
        GLData data = new GLData();
        data.doubleBuffer = true;
        data.samples = 8;
        data.depthSize = 24;
        this.canvas = new GLCanvas(parent, 0, data);
        this.canvas.setSize(width, height);
        this.canvas.setCurrent();
        try {
            GL.createCapabilities();
            this.thread = Thread.currentThread();
        }
        catch (Exception exception) {
            System.out.println("failed to create opengl context!");
            System.exit(1);
        }
        this.canvas.addListener(37, event -> {
            if (this.scene != null) {
                this.scene.getCameraController().mouseScrolled(new MouseEvent(event));
            }
        });
    }

    public void preRender() {
        GL11.glEnable((int)32925);
        GL11.glClearColor((float)0.6f, (float)0.7f, (float)0.9f, (float)1.0f);
        GL11.glClear((int)16640);
        GL11.glPolygonMode((int)1032, (int)6914);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2884);
        GL11.glCullFace((int)1029);
        GL11.glViewport((int)0, (int)0, (int)this.canvas.getSize().x, (int)this.canvas.getSize().y);
    }

    public void render() {
        if (!this.canvas.isDisposed()) {
            this.canvas.setCurrent();
            this.preRender();
            if (this.scene != null) {
                long delta = System.currentTimeMillis() - this.scene.getLastFrame();
                this.scene.render(delta);
            }
            this.canvas.swapBuffers();
        } else {
            this.dispose();
        }
    }

    public void run() {
        RenderingTask task = new RenderingTask(this);
        Display.getDefault().timerExec(1000, (Runnable)task);
    }

    public IScene getScene() {
        return this.scene;
    }

    public void setScene(IScene scene) {
        this.scene = scene;
        this.attachListners();
    }

    private void attachListners() {
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void dispose() {
        render = false;
    }
}

