/*
 * Decompiled with CFR 0.152.
 */
package org.frs.resources.downloder;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.frs.resources.downloder.DownloadObserver;

public class HttpFileDownloader
implements Runnable {
    private final String url;
    private final String outputPath;
    private final String tempOutputPath;
    private final List<DownloadObserver> observers = new ArrayList<DownloadObserver>();
    private volatile boolean paused = false;
    private volatile boolean stopRequested = false;
    private long totalSize = -1L;

    public HttpFileDownloader(String url, String outputPath) {
        this.url = url;
        this.outputPath = outputPath;
        this.tempOutputPath = outputPath + ".download";
    }

    public void addObserver(DownloadObserver observer) {
        this.observers.add(observer);
    }

    public void togglePause() {
        this.paused = !this.paused;
        this.notifyStatus(this.paused ? "T\u00e9l\u00e9chargement en pause..." : "T\u00e9l\u00e9chargement en cours...");
    }

    public void stop() {
        this.stopRequested = true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        tempFile = new File(this.tempOutputPath);
        finalFile = new File(this.outputPath);
        downloadedBytes = tempFile.exists() != false ? tempFile.length() : 0L;
        lastProgress = -1L;
        while (!this.stopRequested) {
            block36: {
                block35: {
                    block34: {
                        conn = null;
                        downloadUrl = new URL(this.url);
                        conn = (HttpURLConnection)downloadUrl.openConnection();
                        conn.setRequestProperty("Range", "bytes=" + downloadedBytes + "-");
                        conn.setConnectTimeout(10000);
                        conn.setReadTimeout(15000);
                        conn.connect();
                        if (this.totalSize != -1L) ** GOTO lbl24
                        contentLength = conn.getContentLengthLong();
                        if (contentLength != -1L) break block34;
                        this.notifyError("Impossible de d\u00e9terminer la taille du fichier.");
                        if (conn != null) {
                            conn.disconnect();
                        }
                        return;
                    }
                    this.totalSize = downloadedBytes + contentLength;
lbl24:
                    // 2 sources

                    contentLength = null;
                    var10_12 = null;
                    in = conn.getInputStream();
                    raf = new RandomAccessFile(this.tempOutputPath, "rw");
                    raf.seek(downloadedBytes);
                    buffer = new byte[4096];
                    this.notifyStatus("T\u00e9l\u00e9chargement en cours...");
                    while ((bytesRead = in.read(buffer)) != -1) {
                        if (!this.stopRequested) ** GOTO lbl38
                        break;
lbl-1000:
                        // 1 sources

                        {
                            Thread.sleep(500L);
lbl38:
                            // 2 sources

                            ** while (this.paused)
                        }
lbl39:
                        // 1 sources

                        raf.write(buffer, 0, bytesRead);
                        progress = (downloadedBytes += (long)bytesRead) * 100L / this.totalSize;
                        if (progress == lastProgress) continue;
                        lastProgress = progress;
                        this.notifyProgress(progress);
                    }
                    if (!this.stopRequested && downloadedBytes >= this.totalSize) {
                        raf.close();
                        renamed = tempFile.renameTo(finalFile);
                        if (!renamed) {
                            try {
                                Files.copy(tempFile.toPath(), finalFile.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                                tempFile.delete();
                                this.notifyCompleted();
                            }
                            catch (IOException e) {
                                this.notifyError("Erreur lors du renommage par copie : " + e.getMessage());
                            }
                        } else {
                            this.notifyCompleted();
                        }
                    }
                    if (raf == null) break block35;
                    raf.close();
                }
                if (in == null) break block36;
                in.close();
            }
            if (conn == null) break;
            conn.disconnect();
            break;
            {
                catch (Throwable contentLength) {
                    try {
                        try {
                            try {
                                try {
                                    if (raf != null) {
                                        raf.close();
                                    }
                                    throw contentLength;
                                }
                                catch (Throwable var10_13) {
                                    if (contentLength == null) {
                                        contentLength = var10_13;
                                    } else if (contentLength != var10_13) {
                                        contentLength.addSuppressed(var10_13);
                                    }
                                    if (in != null) {
                                        in.close();
                                    }
                                    throw contentLength;
                                }
                            }
                            catch (Throwable var10_14) {
                                if (contentLength == null) {
                                    contentLength = var10_14;
                                } else if (contentLength != var10_14) {
                                    contentLength.addSuppressed(var10_14);
                                }
                                throw contentLength;
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            this.notifyError(ex.getMessage());
                            this.notifyError("Connexion perdue. Nouvelle tentative dans 5 secondes...");
                            this.notifyStatus("Erreur r\u00e9seau .");
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException ignored) {
                                this.notifyError(ignored.getMessage());
                            }
                            if (conn == null) continue;
                            conn.disconnect();
                        }
                    }
                    catch (Throwable var17_22) {
                        if (conn != null) {
                            conn.disconnect();
                        }
                        throw var17_22;
                    }
                }
            }
        }
    }

    private void notifyProgress(long percent) {
        for (DownloadObserver observer : this.observers) {
            observer.onProgress(percent);
        }
    }

    private void notifyStatus(String message) {
        for (DownloadObserver observer : this.observers) {
            observer.onStatus(message);
        }
    }

    private void notifyCompleted() {
        String fileName = new File(this.outputPath).getName();
        String message = "Le t\u00e9l\u00e9chargement de \"" + fileName + "\" a \u00e9t\u00e9 termin\u00e9 avec succ\u00e8s.";
        for (DownloadObserver observer : this.observers) {
            observer.onStatus(message);
            observer.onCompleted();
        }
    }

    private void notifyError(String errorMsg) {
        for (DownloadObserver observer : this.observers) {
            observer.onErreur(errorMsg);
        }
    }

    public long getTotalFileSize() {
        if (this.totalSize != -1L) {
            return this.totalSize;
        }
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(this.url).openConnection();
            conn.setRequestMethod("HEAD");
            System.out.println("this is getTotalFileSize");
            conn.connect();
            long size = conn.getContentLengthLong();
            conn.disconnect();
            return size;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static void main(String[] args) {
        Scanner scanner;
        Object outputPath;
        String url;
        block26: {
            boolean tempFileExists;
            url = "http://public.store.frsdev.ovh/resources/ScomLightService_latest.msi";
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            String baseOutputPath = System.getProperty("user.dir") + File.separator + fileName;
            outputPath = baseOutputPath;
            HttpFileDownloader tempDownloader = new HttpFileDownloader(url, baseOutputPath);
            long totalSize = tempDownloader.getTotalFileSize();
            if (totalSize <= 0L) {
                System.err.println("Impossible de r\u00e9cup\u00e9rer la taille du fichier.");
                return;
            }
            scanner = new Scanner(System.in);
            File existingFile = new File(baseOutputPath);
            File existingDownload = new File(baseOutputPath + ".download");
            boolean finishedFileExists = existingFile.exists() && existingFile.length() == totalSize;
            boolean bl = tempFileExists = existingDownload.exists() && existingDownload.length() == totalSize;
            if (finishedFileExists || tempFileExists) {
                int choice;
                System.out.println("Un fichier complet existe d\u00e9j\u00e0 :");
                if (finishedFileExists) {
                    System.out.println("- " + existingFile.getName());
                }
                if (tempFileExists) {
                    System.out.println("- " + existingDownload.getName());
                }
                System.out.println("Que voulez-vous faire ?");
                System.out.println("1: Remplacer");
                System.out.println("2: T\u00e9l\u00e9charger une copie");
                System.out.println("3: Ne rien faire");
                do {
                    System.out.print("Votre choix (1/2/3): ");
                } while ((choice = scanner.nextInt()) < 1 || choice > 3);
                if (choice == 1) {
                    if (finishedFileExists) {
                        existingFile.delete();
                    }
                    if (tempFileExists) {
                        existingDownload.delete();
                    }
                    outputPath = baseOutputPath;
                } else {
                    if (choice == 2) {
                        int i = 1;
                        while (true) {
                            String newPath;
                            File newFile;
                            if (!(newFile = new File(newPath = baseOutputPath.replaceFirst("(\\.\\w+)$", "(" + i + ")$1"))).exists()) {
                                outputPath = newPath;
                                break block26;
                            }
                            ++i;
                        }
                    }
                    System.out.println("Aucune action effectu\u00e9e.");
                    scanner.close();
                    return;
                }
            }
        }
        HttpFileDownloader downloader = new HttpFileDownloader(url, (String)outputPath);
        downloader.addObserver(new DownloadObserver(){

            @Override
            public void onProgress(long percent) {
                System.out.println("Progression: " + percent + "%");
            }

            @Override
            public void onStatus(String message) {
                System.out.println("Statut: " + message);
            }

            @Override
            public void onCompleted() {
                System.out.println("T\u00e9l\u00e9chargement termin\u00e9 !");
            }

            @Override
            public void onErreur(String errorMsg) {
                System.err.println("Erreur: " + errorMsg);
            }
        });
        Thread downloadThread = new Thread(downloader);
        downloadThread.start();
        System.out.println("Tapez 'pause', 'reprendre', ou 'exit' pour contr\u00f4ler :");
        scanner.nextLine();
        while (downloadThread.isAlive()) {
            String command;
            switch (command = scanner.nextLine().trim().toLowerCase()) {
                case "pause": {
                    downloader.togglePause();
                    break;
                }
                case "reprendre": {
                    downloader.togglePause();
                    break;
                }
                case "exit": {
                    downloader.stop();
                    System.out.println("Arr\u00eat demand\u00e9...");
                    return;
                }
                default: {
                    System.out.println("Commande inconnue. Essayez: pause, resume, exit");
                }
            }
        }
        scanner.close();
    }
}

