/*
 * Decompiled with CFR 0.152.
 */
package org.frs.debitage.cam.graphunit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import javax.swing.JPanel;

class LineBreakPanel
extends JPanel {
    private LineBreakMeasurer lineMeasurer;
    private int paragraphStart;
    private int paragraphEnd;
    private static final Hashtable<TextAttribute, Object> map = new Hashtable();
    private static AttributedString vanGogh;

    static {
        map.put(TextAttribute.FAMILY, "Serif");
        map.put(TextAttribute.SIZE, new Float(18.0));
        vanGogh = new AttributedString("Many people believe that Vincent van Gogh painted his best works during the two-year period he spent in Provence. Here is where he painted The Starry Night--which some consider to be his greatest work of all. However, as his artistic brilliance reached new heights in Provence, his physical and mental health plummeted. ", map);
    }

    LineBreakPanel() {
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(Color.white);
        Graphics2D g2d = (Graphics2D)g;
        if (this.lineMeasurer == null) {
            AttributedCharacterIterator paragraph = vanGogh.getIterator();
            this.paragraphStart = paragraph.getBeginIndex();
            this.paragraphEnd = paragraph.getEndIndex();
            FontRenderContext frc = g2d.getFontRenderContext();
            this.lineMeasurer = new LineBreakMeasurer(paragraph, frc);
        }
        float breakWidth = this.getSize().width;
        float drawPosY = 0.0f;
        this.lineMeasurer.setPosition(this.paragraphStart);
        while (this.lineMeasurer.getPosition() < this.paragraphEnd) {
            TextLayout layout = this.lineMeasurer.nextLayout(breakWidth);
            float drawPosX = layout.isLeftToRight() ? 0.0f : breakWidth - layout.getAdvance();
            layout.draw(g2d, drawPosX, drawPosY += layout.getAscent());
            drawPosY += layout.getDescent() + layout.getLeading();
        }
    }
}

