/*
 * Decompiled with CFR 0.152.
 */
package org.frs.serialization_api.json;

import java.util.Map;
import org.frs.serialization_api.abstraction.JavaObjectMapper;
import org.frs.serialization_api.serializer.Serializer;
import org.frs.structures.node.Node;

public class JSONSerializer
implements Serializer {
    private final StringBuilder stringBuilder = new StringBuilder();
    private int indentation;

    @Override
    public String serialize(Object obj) {
        JavaObjectMapper mapper = new JavaObjectMapper();
        Node root = new Node();
        mapper.map(obj, root);
        this.stringBuilder.setLength(0);
        this.indentation = 0;
        return this.toJson((Node<Object>)root);
    }

    public String toJson(Node<Object> node) {
        this.stringBuilder.setLength(0);
        this.indentation = 0;
        this.stringBuilder.append("{\n");
        node.getValue();
        for (Node nodeX : node.getChildren()) {
            this.stringBuilder.append(String.format("\t %s : %s,\n", nodeX.getName(), nodeX.getValue()));
        }
        this.stringBuilder.append("}");
        return this.stringBuilder.toString();
    }

    public String jsonStringify(Map<String, Object> map) {
        this.begin();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.stringBuilder.append(String.format("\t %s:%s,\n", entry.getKey(), this.writeValue(entry.getValue())));
        }
        this.stringBuilder.append("}");
        return this.stringBuilder.toString();
    }

    private String writeValue(Object value) {
        return null;
    }

    private void begin() {
        this.stringBuilder.setLength(0);
        this.indentation = 0;
        this.stringBuilder.append("{\n");
    }

    private String writeValue(String name, Object value) {
        return String.format("%s:%s", name, value);
    }

    private String writeIndentation() {
        Object indentation = "";
        int i = 0;
        while (i < this.indentation) {
            indentation = (String)indentation + "\t";
            ++i;
        }
        return indentation;
    }
}

