package supercad.api.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.util.Base64;

import org.json.simple.JSONObject;


public class MultiPartBodyBuilder {
	
	private String boundary;
	private JSONObject metaData;
	private File file;
	private String body;
	public final static String lineTerminator ="\r\n"; 
	
	public String generateBoundary() {
		SecureRandom random = new SecureRandom();
		byte[] bytes = new byte[16];
		random.nextBytes(bytes);
		return Base64.getUrlEncoder().encodeToString(bytes);
	}
	
	public void build() throws IOException, URISyntaxException {
		Path path = file.toPath();
		FileInputStream inputStream = new FileInputStream(file);
		byte[] bytes = inputStream.readAllBytes();
		inputStream.close();
		String content = Base64.getUrlEncoder().encodeToString(bytes);
		String contentType  = Files.probeContentType(path);
		this.boundary = generateBoundary();
		StringBuilder builder = new StringBuilder();
		//the file part
		builder.append(String.format("--%s%s", boundary, lineTerminator));
		builder.append(String.format("Content-Disposition: form-data; name=\"file\"; filename=\"%s\"%s", file.getName(), lineTerminator));
		builder.append(String.format("Content-Type: %s%s",contentType, lineTerminator));
		builder.append(lineTerminator + content + lineTerminator);
		//the form part
		builder.append(String.format("--%s%s", boundary, lineTerminator));
		builder.append("Content-Disposition: form-data; name=\"metadata\"; filename=\"\"" + lineTerminator);
        builder.append("Content-Type: application/json" + lineTerminator);
        builder.append(lineTerminator + metaData.toJSONString() + lineTerminator);
		builder.append(String.format("--%s--", boundary));
		this.body = builder.toString();
	}
	
	public MultiPartBodyBuilder  metaData(JSONObject json) {
		setMetaData(json);
		return this;
	}
	
	public MultiPartBodyBuilder file(File file) {
		setFile(file);
		return this;
	}
	
	
	
	
	
	public String getBoundary() {
		return boundary;
	}

	public void setBoundary(String boundary) {
		this.boundary = boundary;
	}

	public JSONObject getMetaData() {
		return metaData;
	}

	public void setMetaData(JSONObject metaData) {
		this.metaData = metaData;
	}

	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}
	

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public static void main(String...strings) {
		JSONObject json = new JSONObject();
		json.put("creationDate", LocalDate.now().toString());
		File file = new File("C:\\Users\\nadhe\\OneDrive\\Bureau\\licence.txt");
		MultiPartBodyBuilder bodyBuilder = new MultiPartBodyBuilder();
		try {
			bodyBuilder.file(file).metaData(json).build();
			System.out.println(bodyBuilder.getBody());
		} catch (IOException | URISyntaxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
