package dressing.ui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.emf.MechanicdesignLibrary.ModelEMFLabelProvider;
import gdxapp.assets.AssetsTextures;
import gdxapp.shaders.PbrMaterial;
import param.MaterialType;
import param.Vertice3;
import param.impl.MaterialTypeImpl;
import param.impl.ParamFactoryImpl;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.List;

import java.io.File;
import java.util.HashMap;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.wb.swt.SWTResourceManager;

import com.badlogic.gdx.math.Vector3;

import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;

public class MaterialTypeEditor extends EditorWindow {
 
	private final String NO_MAP = "undefined";

	
	private String filterText=""; 
	private MaterialTypeImpl selectedMtl;
	private Text nom;
	private Text opcacity;
	private Text shininess;
	private Text reflectivity;
	EList<MaterialType> materials =ResourceManagers.getIntance().getMaterialTypesGroup().getMaterialTypes();
	private HashMap<String,Image> tmpImages;
	private ColorComposite grpDiffuse;
	private Text search;
	private ListViewer listViewer;
	private Button btnProduction;
	private Text text;
	private Text txtAlbedoPath;
	private Text textMetalPath;
	private Text textRoughnessPath;
	private Text textAOPath;
	private Text textNormalPath;
	private Button btnImage;


	private ColorComposite grpEmissive;
	public MaterialTypeEditor(Shell parentShell) {
		super(parentShell,EditorWindow.update);
		tmpImages = new HashMap<String, Image>();
		
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		Composite composite = new Composite(parent, SWT.FILL);
		composite.setTouchEnabled(true);
		composite.setLayout(new GridLayout(1, false));
		
		SashForm sashForm = new SashForm(composite, SWT.SMOOTH);
		sashForm.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		ScrolledComposite scrolledComposite = new ScrolledComposite(sashForm, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		scrolledComposite.setExpandHorizontal(true);
		scrolledComposite.setExpandVertical(true);
		
		Composite compositeListe = new Composite(scrolledComposite, SWT.BORDER);
		compositeListe.setLayout(new GridLayout(1, false));
		
		Composite composite_3 = new Composite(compositeListe, SWT.NONE);
		composite_3.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		composite_3.setLayout(new GridLayout(4, false));
		
		Button btnAjouter = new Button(composite_3, SWT.NONE);
		btnAjouter.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, true, 2, 1));
		btnAjouter.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				MaterialType materialType=ParamFactoryImpl.eINSTANCE.createMaterialType();
				materialType.setAlbedo(ParamFactoryImpl.eINSTANCE.createVertice3());
				materials.add(materialType);
				listViewer.setSelection(new StructuredSelection(materialType), true);
				listViewer.refresh();

			}
		});
		btnAjouter.setText("Ajouter");
		btnAjouter.setImage(ResourceManager.getPluginImage("Dressing", "icons/ajout.png"));
		
		Button btnSupprimer = new Button(composite_3, SWT.NONE);
		btnSupprimer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		btnSupprimer.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Object selection = listViewer.getStructuredSelection().getFirstElement();
				materials.remove(selection);
				listViewer.refresh();
			}
		});
		btnSupprimer.setText("Supprimer");
		
		Label lblRechercher = new Label(composite_3, SWT.NONE);
		lblRechercher.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, true, false, 1, 1));
		lblRechercher.setText("Rechercher");
		
		search = new Text(composite_3, SWT.BORDER);
		search.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, true, 3, 1));
		search.setText(filterText);
		search.addKeyListener(new KeyListener() {
			
			@Override
			public void keyReleased(KeyEvent e) {
				filterText=search.getText();
				listViewer.refresh();
			}
			
			@Override
			public void keyPressed(KeyEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		listViewer = new ListViewer(compositeListe, SWT.BORDER | SWT.V_SCROLL);
		List list = listViewer.getList();
		list.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		btnImage = new Button(compositeListe, SWT.NONE);
		GridData gd_btnImage = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_btnImage.heightHint = 200;
		btnImage.setLayoutData(gd_btnImage);
		btnImage.setText("image");
		
		scrolledComposite.setContent(compositeListe);
		scrolledComposite.setMinSize(compositeListe.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		listViewer.setLabelProvider(new MaterialTypeLabelProvider());
		listViewer.setContentProvider(ArrayContentProvider.getInstance());
		listViewer.setInput(materials);
		listViewer.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selections = (IStructuredSelection) event.getSelection();
				// set the selection to the service
				Object selectionobj = selections.getFirstElement();
				if (selectionobj == null) {
					return;
				}
				if(selectionobj instanceof MaterialTypeImpl) {
					MaterialTypeImpl material= (MaterialTypeImpl) selectionobj;
					setmaterial(material);
				}
			}
		});
		listViewer.addFilter(new ViewerFilter() {
			
			@Override
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				if(element instanceof MaterialType) {
					MaterialType material =(MaterialType) element;
					return filterText.equals("")
							|| material.getName().toUpperCase().contains(filterText.toUpperCase());
				}
				return false;
			}
		});
		
		ScrolledComposite scrolledComposite_1 = new ScrolledComposite(sashForm, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		scrolledComposite_1.setExpandHorizontal(true);
		scrolledComposite_1.setExpandVertical(true);
		
		Composite composite_1 = new Composite(scrolledComposite_1, SWT.NONE);
		composite_1.setLayout(new GridLayout(1, false));
		
		Composite composite_2 = new Composite(composite_1, SWT.NONE);
		composite_2.setLayout(new GridLayout(2, false));
		composite_2.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Label lblNom = new Label(composite_2, SWT.NONE);
		lblNom.setText("Nom");
		
		nom = new Text(composite_2, SWT.BORDER);
		nom.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblOpacity = new Label(composite_2, SWT.NONE);
		lblOpacity.setText("Opacity");
		
		opcacity = new Text(composite_2, SWT.BORDER);
		opcacity.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		opcacity.addKeyListener(new DoubleKeyAdapter());
		Label lblShininess = new Label(composite_2, SWT.NONE);
		lblShininess.setText("Roughness");
		
		shininess = new Text(composite_2, SWT.BORDER);
		shininess.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		shininess.addKeyListener(new DoubleKeyAdapter());
		Label lblReflectivity = new Label(composite_2, SWT.NONE);
		lblReflectivity.setText("Metalness");
		
		reflectivity = new Text(composite_2, SWT.BORDER);
		reflectivity.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		reflectivity.addKeyListener(new DoubleKeyAdapter());
		
		Label lblAmbiantOcclusion = new Label(composite_2, SWT.NONE);
		lblAmbiantOcclusion.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblAmbiantOcclusion.setText("Ambiant Occlusion");
		
		text = new Text(composite_2, SWT.BORDER);
		text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		Label Diffuse = new Label(composite_2, SWT.NONE);
		Diffuse.setText("Albedo");
		grpDiffuse = new ColorComposite(composite_2, SWT.NONE);
		grpDiffuse.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		
		Label lblEmissive = new Label(composite_2, SWT.NONE);
		lblEmissive.setText("Emissive");
		
		grpEmissive = new ColorComposite(composite_2, SWT.NONE);
		grpEmissive.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		Label lblBaseColorMap = new Label(composite_2, SWT.NONE);
		lblBaseColorMap.setText("base color map");
		
		Button btnBrowse = new Button(composite_2, SWT.NONE);
		btnBrowse.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				setMapPath(PbrMaterial.BASECOLOR_MAP);
			}
		});
		btnBrowse.setText("...");
		
		txtAlbedoPath = new Text(composite_2, SWT.MULTI);
		txtAlbedoPath.addMouseTrackListener(new MouseTrackAdapter() {
			@Override
			public void mouseHover(MouseEvent e) {
				displayImage(txtAlbedoPath.getText());
			}
		});
		txtAlbedoPath.setFont(SWTResourceManager.getFont("Segoe UI", 7, SWT.NORMAL));
		txtAlbedoPath.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Label lblNormalMap = new Label(composite_2, SWT.NONE);
		lblNormalMap.setText("normal map");
		
		Button btnBrowse_1 = new Button(composite_2, SWT.NONE);
		btnBrowse_1.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				setMapPath(PbrMaterial.NORMAL_MAP);
			}
		});
		btnBrowse_1.setText("...");
		
		textNormalPath = new Text(composite_2, SWT.MULTI);
		textNormalPath.addMouseTrackListener(new MouseTrackAdapter() {
			@Override
			public void mouseHover(MouseEvent e) {
				displayImage(textNormalPath.getText());
			}
		});
		textNormalPath.setFont(SWTResourceManager.getFont("Segoe UI", 7, SWT.NORMAL));
		textNormalPath.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Label lblMetalnessMap = new Label(composite_2, SWT.NONE);
		lblMetalnessMap.setText("metalness map");
		
		Button btnBrowse_2 = new Button(composite_2, SWT.NONE);
		btnBrowse_2.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				setMapPath(PbrMaterial.METALNESS_MAP);

			}
		});
		btnBrowse_2.setText("...");
		
		textMetalPath = new Text(composite_2, SWT.MULTI);
		textMetalPath.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent e) {
				
			}
		});
		textMetalPath.addMouseTrackListener(new MouseTrackAdapter() {
			@Override
			public void mouseHover(MouseEvent e) {
				displayImage(textMetalPath.getText());
			}
		});
		textMetalPath.setFont(SWTResourceManager.getFont("Segoe UI", 7, SWT.NORMAL));
		textMetalPath.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Label lblRoughnessMap = new Label(composite_2, SWT.NONE);
		lblRoughnessMap.setText("roughness map");
		
		Button btnBrowse_2_1 = new Button(composite_2, SWT.NONE);
		btnBrowse_2_1.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				setMapPath(PbrMaterial.ROUGHNESS_MAP);
			}
		});
		btnBrowse_2_1.setText("...");
		
		textRoughnessPath = new Text(composite_2, SWT.MULTI);
		textRoughnessPath.addMouseTrackListener(new MouseTrackAdapter() {
			@Override
			public void mouseHover(MouseEvent e) {
				displayImage(textRoughnessPath.getText());
			}
		});
		textRoughnessPath.setFont(SWTResourceManager.getFont("Segoe UI", 7, SWT.NORMAL));
		textRoughnessPath.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Label lblAoMap = new Label(composite_2, SWT.NONE);
		lblAoMap.setText("ao map");
		
		Button btnBrowse_2_1_1 = new Button(composite_2, SWT.NONE);
		btnBrowse_2_1_1.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				setMapPath(PbrMaterial.AMBIANT_OCCLUSION_MAP);

			}
		});
		btnBrowse_2_1_1.setText("...");
		
		textAOPath = new Text(composite_2, SWT.MULTI);
		textAOPath.addMouseTrackListener(new MouseTrackAdapter() {
			@Override
			public void mouseHover(MouseEvent e) {
				displayImage(textAOPath.getText());
			}
		});
		textAOPath.setFont(SWTResourceManager.getFont("Segoe UI", 7, SWT.NORMAL));
		textAOPath.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		new Label(composite_2, SWT.NONE);
		
		btnProduction = new Button(composite_2, SWT.CHECK);
		btnProduction.setText("Production");
		
		
		
		
		
		Composite composite3= new Composite(composite_1, SWT.NONE);
		composite3.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, false, false, 2, 1));
		composite3.setLayout(new GridLayout(2, false));
		
		Button btnAppliquer = new Button(composite3, SWT.NONE);
		btnAppliquer.setText("Appliquer");
		btnAppliquer.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1));

		Button btnFermer = new Button(composite3, SWT.NONE);
		btnFermer.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1));
		btnFermer.setText("Annuler");

		btnFermer.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				setmaterial(selectedMtl);
			}

		});
		btnAppliquer.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Appliquer();
			}

		});
		scrolledComposite_1.setContent(composite_1);
		scrolledComposite_1.setMinSize(composite_1.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		sashForm.setWeights(new int[] {100, 400});
		return composite;
	}

	protected void setmaterial(MaterialTypeImpl material) {
		selectedMtl =material;
		if(selectedMtl !=null) {
			nom.setText(selectedMtl.getName());
			opcacity.setText(String.valueOf(selectedMtl.getOpacity()));
			shininess.setText(String.valueOf(selectedMtl.getRoughness()));
			reflectivity.setText(String.valueOf(selectedMtl.getMetalness()));
			
			
			Vector3 albedo = new Vector3();
			if(selectedMtl.getAlbedo() != null)
				albedo.set(selectedMtl.getAlbedo().getR(), selectedMtl.getAlbedo().getG(), selectedMtl.getAlbedo().getB());
			grpDiffuse.setColor(albedo);
				
			txtAlbedoPath.setText(selectedMtl.getAlbedoMapPath()==null?NO_MAP:selectedMtl.getAlbedoMapPath());
			textNormalPath.setText(selectedMtl.getNormalMapPath()==null?NO_MAP:selectedMtl.getNormalMapPath());
			textMetalPath.setText(selectedMtl.getMetalnessMapPath()==null?NO_MAP:selectedMtl.getMetalnessMapPath());
			textRoughnessPath.setText(selectedMtl.getRoughnessMapPath() == null?NO_MAP:selectedMtl.getRoughnessMapPath());
			textAOPath.setText(selectedMtl.getAoMapPath()==null?NO_MAP:selectedMtl.getAoMapPath());			
			btnProduction.setSelection(selectedMtl.isProduction());
			Vector3 emissive = new Vector3();
			if(selectedMtl.getEmissive() != null)
				emissive.set(selectedMtl.getEmissive().getR(), selectedMtl.getEmissive().getG(), selectedMtl.getEmissive().getB());
			grpEmissive.setColor(emissive);
		}else {
			nom.setText("");
			opcacity.setText("");
			shininess.setText("");
			reflectivity.setText("");
			grpDiffuse.setColor(ParamFactoryImpl.eINSTANCE.createVertice3());
			grpEmissive.setColor(ParamFactoryImpl.eINSTANCE.createVertice3());
			btnProduction.setSelection(false);
			txtAlbedoPath.setText("");
			textNormalPath.setText("");
			textMetalPath.setText("");
			textRoughnessPath.setText("");
			textAOPath.setText("");
		}
	}
	
	private void displayImage(String key) {
		if(key.contentEquals(NO_MAP) || key=="")
			return;
		Image image = tmpImages.get(key);
		if(image == null) {
			try {
				image = new Image(Display.getCurrent(), key);
				if(image != null) {
					image = new Image(Display.getCurrent(), image.getImageData().scaledTo(200, 200));
					this.tmpImages.put(key, image);
				}
			}catch (Exception e) {
				System.err.println(e);
			}
		}
		if(image != null)
			btnImage.setImage(image);
	}
	
	private void setMapPath(int mapAlias) {
		FileDialog dialog = new FileDialog(getShell(), SWT.OPEN);
		dialog.setFilterExtensions(new String[] { "*.jpg; *.png; *.bmp; *.tif"});
		String filepath = dialog.open();
		if(filepath != null) {
			switch(mapAlias) {
			case(PbrMaterial.BASECOLOR_MAP):
				selectedMtl.setAlbedoMapPath(filepath);
				txtAlbedoPath.setText(filepath);
				break;
			case(PbrMaterial.NORMAL_MAP):
				selectedMtl.setNormalMapPath(filepath);
				textNormalPath.setText(filepath);
				break;
			case(PbrMaterial.METALNESS_MAP):
				selectedMtl.setMetalnessMapPath(filepath);
				textMetalPath.setText(filepath);
				break;
			case(PbrMaterial.ROUGHNESS_MAP):
				selectedMtl.setRoughnessMapPath(filepath);
				textRoughnessPath.setText(filepath);
				break;
			default:
				selectedMtl.setAoMapPath(filepath);
				textAOPath.setText(filepath);
			}
			
			Image image;
			image = this.tmpImages.get(filepath);
			if(image == null) {
				image = new Image(Display.getCurrent(), filepath);
				image = new Image(Display.getCurrent(), image.getImageData().scaledTo(200, 200));
				this.tmpImages.put(filepath, image);
			}else {
				btnImage.setImage(image);
			}
		}
	}
	
	
	
	public void Appliquer() {
		selectedMtl.setName(nom.getText());
		selectedMtl.setOpacity(Float.valueOf(opcacity.getText()));
		selectedMtl.setRoughness(Float.valueOf(shininess.getText()));
		selectedMtl.setMetalness(Float.valueOf(reflectivity.getText()));
		selectedMtl.setProduction(btnProduction.getSelection());
		selectedMtl.setAlbedo(grpDiffuse.getEmfColor());
		selectedMtl.setEmissive(grpEmissive.getEmfColor());

		String albedoPath = txtAlbedoPath.getText();
		if(albedoPath.equals(NO_MAP) || albedoPath.equals(""))
			albedoPath = null;
		
		String normalPath = textNormalPath.getText();
		if(normalPath.equals(NO_MAP) || normalPath.equals(""))
			normalPath = null;
		
		String roughnessPath = textRoughnessPath.getText();
		if(roughnessPath.equals(NO_MAP) || roughnessPath.equals(""))
			roughnessPath = null;
		
		String metalnessPath = textMetalPath.getText();
		if(metalnessPath.equals(NO_MAP) || metalnessPath.equals(""))
			metalnessPath = null;
		
		String aoPath = textAOPath.getText();
		if(aoPath.equals(NO_MAP) || aoPath.equals(""))
			aoPath = null;
		
		selectedMtl.setAlbedoMapPath(albedoPath);
		selectedMtl.setNormalMapPath(normalPath);
		selectedMtl.setRoughnessMapPath(roughnessPath);
		selectedMtl.setMetalnessMapPath(metalnessPath);
		selectedMtl.setAoMapPath(aoPath);

		listViewer.refresh();
		ResourceManagers.getIntance().saveLibraryResource();

	}
	@Override
	public boolean terminer() {
		for(MaterialType materialType: materials) {
			PbrMaterial pbrMaterial = new PbrMaterial(materialType);
			pbrMaterial.cacheMaps();
			
		}
		ResourceManagers.getIntance().saveMaterialTypes();
		AssetsTextures.getInstance().loadMaterialsfromEMF();
		finish();
		return true;
	}
	class MaterialTypeLabelProvider extends LabelProvider{

		@Override
		public String getText(Object element) {
			if(element instanceof MaterialType) {
				return ((MaterialType) element).getName();
			}
			return element.toString();
		}
		
	}
	@Override
	public boolean check() {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	protected void cancel() {
		// TODO Auto-generated method stub
		
	}
	
	
	
}
