package dressing.ui.util;

import org.eclipse.jface.viewers.LabelProvider;

import param.Chant;
import param.GestionElement;

public class GestionLabelProvider extends LabelProvider {
		private static GestionLabelProvider instance;
		public static GestionLabelProvider getInstance() {
			synchronized(GestionLabelProvider.class) {
				if (instance == null) {
					instance = new GestionLabelProvider();
				}
				return instance;
			}
		}
		@Override
		public String getText(Object element) {
			if(element!=null && element instanceof GestionElement)
			{
				GestionElement value=(GestionElement) element;
				return value.getName();

			}else if(element!=null && element instanceof Chant chant)
			{
				return chant.getName();

			}else {
				return "";
			}
		}
	}