/*
 * Decompiled with CFR 0.152.
 */
package org.frs.debitage.engine.core.evalutor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;

public class GeomtericEngineManager {
    private List<GeomtericEngine> engines = new ArrayList<GeomtericEngine>();
    private ConcurrentLinkedQueue<GeomtericEngine> enginesPool = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<GeomtericEngine> enginesToCleanPool = new ConcurrentLinkedQueue();
    private static GeomtericEngineManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeomtericEngineManager getInstance() {
        Class<GeomtericEngineManager> clazz = GeomtericEngineManager.class;
        synchronized (GeomtericEngineManager.class) {
            if (instance == null) {
                instance = new GeomtericEngineManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized List<GeomtericEngine> getEngines() {
        return this.engines;
    }

    public synchronized GeomtericEngine getGeomtericEngine() {
        GeomtericEngine engine = this.enginesPool.poll();
        if (engine == null) {
            return new GeomtericEngine(this);
        }
        return engine;
    }

    public synchronized void cleanEngine(GeomtericEngine engine) {
        this.enginesToCleanPool.add(engine);
    }
}

