/*
 * Decompiled with CFR 0.152.
 */
package org.frs.debitage.engine.core.evalutor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import org.frs.debitage.engine.core.evalutor.GeomtericEngineManager;
import org.mozilla.javascript.engine.RhinoScriptEngineFactory;

public class GeomtericEngine {
    private static RhinoScriptEngineFactory engineFactory = new RhinoScriptEngineFactory();
    private static ScriptEngine engine = engineFactory.getScriptEngine();
    private static ScriptEngine logicalEngine = engineFactory.getScriptEngine();
    private ArrayList<Equation> equations = new ArrayList();
    private ArrayList<Equation> forwardequations = new ArrayList();
    private ArrayList<String> dependencystack = new ArrayList();
    private GeomtericEngineManager manager;
    private static GeomtericEngine instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeomtericEngine getInstance() {
        Class<GeomtericEngine> clazz = GeomtericEngine.class;
        synchronized (GeomtericEngine.class) {
            if (instance == null) {
                instance = new GeomtericEngine();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public GeomtericEngine(GeomtericEngineManager manager) {
        this.manager = manager;
    }

    public GeomtericEngine() {
    }

    public void setEquations(ArrayList<Equation> equations) {
        this.equations = equations;
    }

    public ArrayList<Equation> getEquations() {
        return this.equations;
    }

    public void resolveAll() throws GeometricEngineException {
        this.dependencystack.clear();
        for (Equation equ : this.equations) {
            equ.reset();
        }
        for (Equation equ : this.equations) {
            if (equ.isEvaluated()) continue;
            equ.resolve(engine, this.equations, this.dependencystack);
        }
    }

    public void reset() {
        this.dependencystack.clear();
        for (Equation equ : this.equations) {
            equ.reset();
        }
    }

    public void resolveEquation(Equation equ) throws GeometricEngineException {
        equ.resolve(engine, this.equations, this.dependencystack);
    }

    private Set<String> parseDependencies(String equation) {
        HashSet<String> dependencies = new HashSet<String>();
        String regex = "@\\w*\\.\\w*@";
        Matcher matcher = Pattern.compile(regex).matcher(equation);
        while (matcher.find()) {
            dependencies.add(equation.substring(matcher.start(), matcher.end()));
        }
        return dependencies;
    }

    public void resolveforward(String key, double value) throws GeometricEngineException {
        this.dependencystack.clear();
        this.forwardequations.clear();
        this.forwardchaining(key);
        for (Equation equ : this.forwardequations) {
            equ.reset();
        }
        Equation startequation = Equation.FIND_EQUATION(key, this.equations);
        if (startequation == null) {
            throw new GeometricEngineException("Symbol not found " + key);
        }
        startequation.setEvaluation(value);
        startequation.printEvaluation();
        for (Equation equ : this.forwardequations) {
            if (equ.isEvaluated()) continue;
            equ.resolve(engine, this.equations, this.dependencystack);
        }
    }

    private void forwardchaining(String key) throws GeometricEngineException {
        for (Equation equ : this.equations) {
            if (!equ.isDependentTo(key)) continue;
            if (!this.forwardequations.contains(equ)) {
                this.forwardequations.add(equ);
                this.forwardchaining(equ.getKey());
                continue;
            }
            throw new GeometricEngineException("Inifinite dependency loop " + key + " in equation " + equ.getKey() + " = " + equ.getExpr());
        }
    }

    public static final ScriptEngine getEngine() {
        return engine;
    }

    public static final ScriptEngine getLogicalEngine() {
        return logicalEngine;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void dispose() {
        this.equations.clear();
        this.forwardequations.clear();
        this.dependencystack.clear();
    }
}

