package dressing.ui;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

import dressing.config.persistence.ResourceManagers;
import dressing.model.elementsViewProviders.ElementProviderImp;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.GestionLabelProvider;
import dressing.ui.util.ListEditorWindow;
import param.Finition;
import param.Nature_panneaux;
import param.ParamFactory;

public class NaturePanneauxComboSelect extends ElementComboSelect {

	public NaturePanneauxComboSelect(Composite parent, int style) {
		super(parent, style);
		// TODO Auto-generated constructor stub
	}

	@Override
	public IContentProvider getContentProvider() {
		return ArrayContentProvider.getInstance();
	}

	@Override
	public IBaseLabelProvider getLabelProvider() {
		return GestionLabelProvider.getInstance();

	}

	@Override
	public Object getinput() {
		ArrayList<Object> input=new ArrayList<Object>();
		input.add(new Object());
		input.addAll(ResourceManagers.getIntance().getGestion().getNaturePanneaux().getNatures());
		return input;
	}

	@Override
	public void addElement() {
		Nature_panneaux nature=ParamFactory.eINSTANCE.createNature_panneaux();
		nature.setName("");
		NaturePanneauxEditorWindow nature_panneauxEditorWindow = new NaturePanneauxEditorWindow(getShell(),nature,EditorWindow.create);
		nature_panneauxEditorWindow.create();
		int ret=nature_panneauxEditorWindow.open();
		if(ret==Window.OK) {
			getComboViewer().setInput(getinput());
			getComboViewer().refresh();
			
			getComboViewer().setSelection(new StructuredSelection(nature), true);
		}
	}

//	@Override
//	public void listElements() {
//		NaturePanneauxListWindow frsListWindow = new NaturePanneauxListWindow(getShell(),null);
//		frsListWindow.create();
//		int ret=frsListWindow.open();
//		getComboViewer().setInput(getinput());
//		getComboViewer().refresh();
//	}

	@Override
	public void Modify() {
		Object selection=getComboViewer().getStructuredSelection().getFirstElement();
		if(selection!=null && selection instanceof Nature_panneaux) {
			Nature_panneaux nature=(Nature_panneaux) selection;
			NaturePanneauxEditorWindow nature_panneauxEditorWindow = new NaturePanneauxEditorWindow(getShell(),nature,EditorWindow.update);
			nature_panneauxEditorWindow.create();
			int ret=nature_panneauxEditorWindow.open();
			if(ret==Window.OK) {
				getComboViewer().refresh();
			}
		}
		
	}
	@Override
	public ListEditorWindow getListEditorWindow() {
		return new NaturePanneauxListWindow(getShell(),null);
	}
}
