/*
 * Decompiled with CFR 0.152.
 */
package org.frs.cryptool.api.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DualListBox
extends Composite {
    private final List sourceList = new ArrayList();
    private final List targetList = new ArrayList();
    private org.eclipse.swt.widgets.List lstSrc;
    private org.eclipse.swt.widgets.List lstTarget;

    public DualListBox(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(4, false));
        this.lstSrc = new org.eclipse.swt.widgets.List((Composite)this, 2048);
        this.lstSrc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Button btnInclude = new Button((Composite)this, 0);
        btnInclude.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                int selection = DualListBox.this.lstSrc.getSelectionIndex();
                if (selection >= 0) {
                    DualListBox.this.move(selection, DualListBox.this.sourceList, DualListBox.this.targetList);
                }
            }
        });
        btnInclude.setText(">>");
        Button btnExclude = new Button((Composite)this, 0);
        btnExclude.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                int selection = DualListBox.this.lstTarget.getSelectionIndex();
                if (selection >= 0) {
                    DualListBox.this.move(selection, DualListBox.this.targetList, DualListBox.this.sourceList);
                }
            }
        });
        btnExclude.setText("<<");
        this.lstTarget = new org.eclipse.swt.widgets.List((Composite)this, 2048);
        this.lstTarget.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    protected void move(int selection, List src, List target) {
        Object item = src.get(selection);
        src.remove(item);
        target.add(item);
        this.synchViewer(this.sourceList, this.lstSrc);
        this.synchViewer(this.targetList, this.lstTarget);
    }

    private void synchViewer(List model, org.eclipse.swt.widgets.List viewer) {
        viewer.removeAll();
        for (Object item : model) {
            viewer.add(item.toString());
        }
        viewer.select(-1);
    }

    public void setInput(List items) {
        this.sourceList.addAll(items);
        this.synchViewer(this.sourceList, this.lstSrc);
    }
}

