package dressing.ui.project;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import dressing.controller.ProjectCreator;
import dressing.model.SuperCadProject.ProjectType;

public class CreateProjectComposite extends Composite{
	
	private DataBindingContext bindingContext;
	private Text txtProjectName;
	private Text txtClt;
	private Text txtCommercial;
	private Text txtSite;
	private ProjectCreator creator;
	private Text txtClientNumber;
	private Text txtCommercialPhone;

	public CreateProjectComposite(Composite parent, int style, ProjectCreator creator) {
		super(parent, style);
		this.creator=creator;
		getShell().setSize(440, 400);
		getShell().setLocation(getDisplay().getBounds().width/2 - 220, getDisplay().getBounds().height/2 - 200);
		setLayout(new FillLayout(SWT.HORIZONTAL));
		
		Group grpNouveauProjet = new Group(this, SWT.NONE);
		grpNouveauProjet.setText("Nouveau Projet");
		grpNouveauProjet.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		Composite composite = new Composite(grpNouveauProjet, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));
		
		Label lblNomProjet = new Label(composite, SWT.NONE);
		lblNomProjet.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNomProjet.setText("Nom de projet: ");
		
		txtProjectName = new Text(composite, SWT.BORDER);
		txtProjectName.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		
		Label lblClient = new Label(composite, SWT.NONE);
		lblClient.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblClient.setText("Client: ");
		
		txtClt = new Text(composite, SWT.BORDER);
		txtClt.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		
		Label lblTlphone = new Label(composite, SWT.NONE);
		lblTlphone.setText("Téléphone: ");
		
		txtClientNumber = new Text(composite, SWT.BORDER);
		txtClientNumber.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblCommercial = new Label(composite, SWT.NONE);
		lblCommercial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblCommercial.setText("Commercial: ");
		
		txtCommercial = new Text(composite, SWT.BORDER);
		txtCommercial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblMobileCommercial = new Label(composite, SWT.NONE);
		lblMobileCommercial.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblMobileCommercial.setText("Mobile Commercial: ");
		
		txtCommercialPhone = new Text(composite, SWT.BORDER);
		txtCommercialPhone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblSite = new Label(composite, SWT.NONE);
		lblSite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblSite.setText("Site: ");
		
		txtSite = new Text(composite, SWT.BORDER);
		txtSite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		
		
		if(this.creator != null) {
			if (bindingContext != null) {
				bindingContext.dispose();
				bindingContext = null;
			}
			bindingContext = initDataBindings();
		}
	}
	
	public ProjectCreator getCreator() {
		return creator;
	}

	public void setCreator(ProjectCreator creator) {
		this.creator = creator;
		if(this.creator != null) {
			if (bindingContext != null) {
				bindingContext.dispose();
				bindingContext = null;
			}
			bindingContext = initDataBindings();
		}
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtProjectNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtProjectName);
		IObservableValue projectNameCreatorObserveValue = BeanProperties.value("projectName").observe(creator);
		bindingContext.bindValue(observeTextTxtProjectNameObserveWidget, projectNameCreatorObserveValue, null, null);
		//
		IObservableValue observeTextTxtCltObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtClt);
		IObservableValue clientCreatorObserveValue = BeanProperties.value("client").observe(creator);
		bindingContext.bindValue(observeTextTxtCltObserveWidget, clientCreatorObserveValue, null, null);
		//
		IObservableValue observeTextTxtCltNumberObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtClientNumber);
		IObservableValue clientNumberCreatorObserveValue = BeanProperties.value("clientNumber").observe(creator);
		bindingContext.bindValue(observeTextTxtCltNumberObserveWidget, clientNumberCreatorObserveValue, null, null);
		//
		IObservableValue observeTextTxtCommercialObserveWidget = WidgetProperties.text(SWT.Modify).observe(txtCommercial);
		IObservableValue commercialCreatorObserveValue = BeanProperties.value("commercial").observe(creator);
		bindingContext.bindValue(observeTextTxtCommercialObserveWidget, commercialCreatorObserveValue, null, null);
		//
		IObservableValue observeTextTxtSiteObserveWidget = WidgetProperties.text(SWT.Modify).observe(txtSite);
		IObservableValue siteCreatorObserveValue = BeanProperties.value("site").observe(creator);
		bindingContext.bindValue(observeTextTxtSiteObserveWidget, siteCreatorObserveValue, null, null);
		//
		IObservableValue observeTextTxtCommercialPhoneObserveWidget = WidgetProperties.text(SWT.Modify).observe(txtCommercialPhone);
		IObservableValue commericalPhoneCreatorObserveValue = BeanProperties.value("commericalPhone").observe(creator);
		bindingContext.bindValue(observeTextTxtCommercialPhoneObserveWidget, commericalPhoneCreatorObserveValue, null, null);
		//
		return bindingContext;
	}
}
