package dressing.ui;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import param.Country;
import param.Finition;
import param.Fournisseur_fabricant;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.widgets.Button;
import org.eclipse.core.databinding.beans.typed.PojoProperties;

public class CountryEditorWindow extends EditorWindow {
	private Country country;
	private Country countryOrigin;
	Composite parentComposite;
	private Composite clientArea;
	private Text txtName;
	private Text txtCodeNet;
	private Label lblCodeTlphone;
	private Label lblCodePostal;
	private Text txtCodeTel;
	private Text txtCodePostal;

	public CountryEditorWindow(Shell parentShell,Country country,int update) {
		super(parentShell,update);	
		this.country=country;
		this.countryOrigin=EcoreUtil.copy(country);
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(2, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		Label lblName = new Label(clientArea, SWT.NONE);
		lblName.setText("Nom");
		
		txtName = new Text(clientArea, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		lblCodePostal = new Label(clientArea, SWT.NONE);
		lblCodePostal.setText("Code");
		
		txtCodePostal = new Text(clientArea, SWT.BORDER);
		txtCodePostal.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblEp = new Label(clientArea, SWT.NONE);
		lblEp.setText("Code Internet");
		
		txtCodeNet = new Text(clientArea, SWT.BORDER);
		txtCodeNet.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		lblCodeTlphone = new Label(clientArea, SWT.NONE);
		lblCodeTlphone.setText("Code Téléphone");
		
		txtCodeTel = new Text(clientArea, SWT.BORDER);
		txtCodeTel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		this.shell.setText("Editeur Pays");
		parent.requestLayout();
		if(country!=null) {
			initDataBindings();
		}
		return clientArea;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		String originName =txtName.getText().trim();

		this.country.setName(originName);
		if(getUpdateMode()==EditorWindow.create) {
			ResourceManagers.getIntance().getGestion().getCountries().add(country);
		}
		ResourceManagers.getIntance().saveGestion();
		finish();
		return true;
	}
	
	@Override
	protected void cancel() {
		this.country.setName(this.countryOrigin.getName());

	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		return !errorExist;
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameChantObserveValue = PojoProperties.value("name").observe(country);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameChantObserveValue, null, null);
		//
		IObservableValue observeTextTxtCodeNetObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtCodeNet);
		IObservableValue codeNetCountryObserveValue = PojoProperties.value("codeNet").observe(country);
		bindingContext.bindValue(observeTextTxtCodeNetObserveWidget, codeNetCountryObserveValue, null, null);
		//
		IObservableValue observeTextTxtCodeTelObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtCodeTel);
		IObservableValue codeTelCountryObserveValue = PojoProperties.value("codeTel").observe(country);
		bindingContext.bindValue(observeTextTxtCodeTelObserveWidget, codeTelCountryObserveValue, null, null);
		//
		IObservableValue observeTextTxtCodePostalObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtCodePostal);
		IObservableValue codePostalCountryObserveValue = PojoProperties.value("codePostal").observe(country);
		bindingContext.bindValue(observeTextTxtCodePostalObserveWidget, codePostalCountryObserveValue, null, null);
		//
		return bindingContext;
	}
}
