package dressing.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class PreferencesProporties extends Properties {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4725661297599346347L;

	public PreferencesProporties() {
		super();
		init();
	}
	protected abstract String getPath();
	private void init() {
		InputStream in = null;
		try {
			File file=new File(getPath());
			if(!file.exists()) {
				file.createNewFile();
			}
			in = new FileInputStream(file);
			load(in);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			try {
				if (in != null) {
					in.close();
				}
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

	}

	@Override
	public String getProperty(String key, String defaultValue) {
		if (getProperty(key) == null) {
			put(key, defaultValue);
			save();
			return defaultValue;
		}
		return super.getProperty(key, defaultValue);
	}
	public boolean getProperty(String key, boolean defaultValue) {
		return Boolean.valueOf(getProperty(key, String.valueOf(defaultValue)));
	}
	public double getProperty(String key, double defaultValue) {
		return Double.valueOf(getProperty(key, String.valueOf(defaultValue)));
	}
	public void put(String key,boolean value) {
		put(key,String.valueOf(value));
	}
	public void save() {

		try {
			File file=new File(getPath());
			if(!file.exists()) {
				file.createNewFile();
			}
			this.store(new FileOutputStream(file), null);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
}
