/*
 * Decompiled with CFR 0.152.
 */
package org.frs.cryptool.api.security.client;

import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import java.security.PrivateKey;
import java.time.Instant;
import java.util.Map;
import org.frs.cryptool.api.keys.KeyVault;
import org.frs.cryptool.api.security.client.Authentication;
import org.frs.cryptool.api.security.client.IAuthenticationService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IAuthenticationService.class})
public class AuthenticationServiceImpl
implements IAuthenticationService {
    @Reference
    private KeyVault keyVault;
    private Authentication authentication;

    public boolean isLicenseValid() {
        return false;
    }

    public KeyVault getKeyVault() {
        return this.keyVault;
    }

    public void setKeyVault(KeyVault keyVault) {
        this.keyVault = keyVault;
    }

    @Override
    public Authentication authenticate(String license) throws Exception {
        if (this.verifySignature(license)) {
            String jweString = JWSObject.parse((String)license).getPayload().toJSONObject().getOrDefault("license", "");
            Map<String, Object> payload = this.decryptLicense(jweString);
            this.authentication = new Authentication();
            String modules = (String)payload.get("modules");
            if (modules != null) {
                this.authentication.setActiveModules(modules.split("\\s+"));
            }
            Object expiry = payload.get("exp");
            Instant expiracy = Instant.ofEpochSecond((Long)expiry);
            this.authentication.setExpiracyDate(expiracy);
        }
        return this.authentication;
    }

    private Map<String, Object> decryptLicense(String cipher) throws Exception {
        RSADecrypter decrypter = new RSADecrypter((PrivateKey)this.keyVault.getProductKey());
        JWEObject jwe = JWEObject.parse((String)cipher);
        jwe.decrypt((JWEDecrypter)decrypter);
        return jwe.getPayload().toJSONObject();
    }

    @Override
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public boolean verifySignature(String license) {
        boolean result = false;
        try {
            RSASSAVerifier verifier = new RSASSAVerifier(this.keyVault.getServerKey());
            JWSObject jws = JWSObject.parse((String)license);
            result = jws.verify((JWSVerifier)verifier);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

