/*
 * Decompiled with CFR 0.152.
 */
package org.frs.debitage.cam.graphunit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.io.Serializable;
import org.frs.debitage.cam.graphunit.LinesTypes;
import org.frs.debitage.cam.graphunit.PGraph;

public class PLine
extends PGraph
implements Serializable {
    private static final long serialVersionUID = 352L;
    public Color color;
    public Point Satrtpoint;
    public Point EndPoint;
    Stroke LineStroke;
    Line2D LineShape;
    LinesTypes LType;

    @Override
    public void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.color);
        g2d.setStroke(this.LineStroke);
        g2d.draw(this.LineShape);
    }

    public PLine(Point Satrtpoint, Point EndPoint) {
        this.Satrtpoint = Satrtpoint;
        this.EndPoint = EndPoint;
    }

    public PLine(Color icolor, int iThikness, Point ipointstart, Point ipointend) {
        this.LineStroke = new BasicStroke(iThikness);
        this.color = icolor;
        this.Satrtpoint = new Point();
        this.EndPoint = new Point();
        this.Satrtpoint = ipointstart;
        this.EndPoint = ipointend;
        this.LType = LinesTypes.DIAGONAL;
        this.LineShape = new Line2D.Float(this.Satrtpoint.x, this.Satrtpoint.y, this.EndPoint.x, this.EndPoint.y);
    }

    public PLine(Color icolor, int iThikness, LinesTypes iLType, Point ipoint, int iDistance) {
        this.LineStroke = new BasicStroke(iThikness);
        this.color = icolor;
        this.Satrtpoint = new Point();
        this.EndPoint = new Point();
        if (iLType.equals(LinesTypes.HORIZONTAL)) {
            this.LType = LinesTypes.HORIZONTAL;
            this.Satrtpoint = ipoint;
            this.EndPoint.x = this.Satrtpoint.x + iDistance;
            this.EndPoint.y = this.Satrtpoint.y;
            this.LineShape = new Line2D.Float(this.Satrtpoint.x, this.Satrtpoint.y, this.EndPoint.x, this.EndPoint.y);
        } else if (iLType.equals(LinesTypes.VERTICAL)) {
            this.LType = LinesTypes.VERTICAL;
            this.Satrtpoint = ipoint;
            this.EndPoint.x = this.Satrtpoint.x;
            this.EndPoint.y = this.Satrtpoint.y + iDistance;
            this.LineShape = new Line2D.Float(this.Satrtpoint.x, this.Satrtpoint.y, this.EndPoint.x, this.EndPoint.y);
        }
    }

    public Point getSatrtpoint() {
        return this.Satrtpoint;
    }

    public Point getEndPoint() {
        return this.EndPoint;
    }

    @Override
    public String getDXFLineEntetity() {
        String s = "0\nLINE\n8\n0\n";
        s = String.valueOf(s) + "10\n";
        s = String.valueOf(s) + this.Satrtpoint.x + ".0\n";
        s = String.valueOf(s) + "20\n";
        s = String.valueOf(s) + this.Satrtpoint.y + ".0\n";
        s = String.valueOf(s) + "11\n";
        s = String.valueOf(s) + this.EndPoint.x + ".0\n";
        s = String.valueOf(s) + "21\n";
        s = String.valueOf(s) + this.EndPoint.y + ".0\n";
        return s;
    }
}

