/*
 * Decompiled with CFR 0.152.
 */
package org.frs.debitage.cam.graphunit;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.frs.debitage.cam.graphunit.PGraph;
import org.frs.debitage.cam.graphunit.PText;

public class HachedShape
extends PGraph
implements Serializable {
    private static final long serialVersionUID = 352L;
    public Point Startpoint;
    public int Width;
    public int Height;
    public Rectangle2D.Double rec;
    public double angle = 45.0;
    public double distance = 20.0;
    public Shape shape;
    public float hatchStrokeWidth = 0.1f;
    public Color hatchColor = Color.black;
    PText text;
    String texte = " ";
    Point temppoint;
    public int textsize = 15;
    public Font f;

    public HachedShape(Point ipoint, int iWidth, int iHeight) {
        this.Startpoint = new Point();
        this.Startpoint = ipoint;
        this.Width = iWidth;
        this.Height = iHeight;
        this.rec = new Rectangle2D.Double(ipoint.x, ipoint.y, iWidth, iHeight);
        this.f = new Font("SansSerif", 1, this.textsize);
        this.dohash();
    }

    public HachedShape(Point ipoint, int iWidth, int iHeight, double iangle, double idistance, String itext) {
        this.Startpoint = new Point();
        this.Startpoint = ipoint;
        this.Width = iWidth;
        this.Height = iHeight;
        this.rec = new Rectangle2D.Double(ipoint.x, ipoint.y, iWidth, iHeight);
        this.angle = iangle;
        this.distance = idistance;
        this.texte = itext;
        this.f = new Font("SansSerif", 1, this.textsize);
        this.dohash();
    }

    private void dohash() {
        Path2D.Double path = new Path2D.Double();
        Rectangle2D bounds = this.rec.getBounds2D();
        double cx = bounds.getCenterX();
        double cy = bounds.getCenterY();
        double d = Math.max(bounds.getHeight(), bounds.getWidth());
        double y = cy - d;
        while (y < cy + d) {
            ((Path2D)path).moveTo(cx - d, y);
            ((Path2D)path).lineTo(cx + d, y);
            y += this.distance;
        }
        double theta = this.angle * Math.PI / 180.0;
        AffineTransform at = AffineTransform.getRotateInstance(theta, cx, cy);
        this.shape = path.createTransformedShape(at);
    }

    @Override
    public void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.draw(this.rec);
        g2d.setClip(this.rec);
        g2d.setColor(this.hatchColor);
        g2d.draw(this.shape);
        g2d.setFont(this.f);
        g2d.setColor(Color.BLUE);
        this.drawCenteredString(this.texte, this.Width, this.Height, g2d);
    }

    public void drawCenteredString(String s, int w, int h, Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.temppoint = new Point();
        this.temppoint.x = this.Startpoint.x;
        this.temppoint.y = this.Startpoint.y;
        FontMetrics fm = g2d.getFontMetrics();
        while (w - fm.stringWidth(s) < 0) {
            --this.textsize;
            this.f = new Font("SansSerif", 1, this.textsize);
            g2d.setFont(this.f);
            fm = g2d.getFontMetrics();
        }
        --this.textsize;
        this.f = new Font("SansSerif", 1, this.textsize);
        g2d.setFont(this.f);
        fm = g2d.getFontMetrics();
        int x = (w - fm.stringWidth(s)) / 2 + this.temppoint.x;
        int y = fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2 + this.temppoint.y;
        g2d.drawString(s, x, y);
    }
}

